% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{UKLungCancerDeaths_df}
\alias{UKLungCancerDeaths_df}
\title{Lung Cancer Deaths among UK Physicians}
\format{
A data frame with 63 observations and 4 variables:
\describe{
  \item{years.smok}{Years of smoking categorized into 9 levels (factor).}
  \item{cigarettes}{Cigarette consumption categorized into 7 levels (factor).}
  \item{Time}{Exposure time in person-years (numeric).}
  \item{y}{Number of lung cancer deaths (numeric).}
}
}
\source{
Data taken from the SMPracticals package.
Based on the study by Frome, E. L. (1983): *The analysis of rates using Poisson regression models*. Biometrics, 39, 665–674.
}
\usage{
data(UKLungCancerDeaths_df)
}
\description{
This dataset, UKLungCancerDeaths_df, is a data frame containing the number of deaths due to lung cancer among British male physicians. The data is categorized by years of smoking and cigarette consumption and was originally used in Frome (1983) to analyze rates using Poisson regression models.
}
\details{
The dataset name has been kept as 'UKLungCancerDeaths_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
