.First.lib <- function(lib, pkg) {
	library.dynam(pkg, lib.loc=lib)
}	

if (exists("autoload")){
	autoload("survexp.us","ratetables")
	autoload("survexp.uswhite","ratetables")
	autoload("survexp.usr","ratetables")
	autoload("survexp.az","ratetables")
	autoload("survexp.azr","ratetables")
	autoload("survexp.fl","ratetables")
	autoload("survexp.flr","ratetables")
	autoload("survexp.mn","ratetables")
	autoload("survexp.mnwhite","ratetables")
	autoload("survexp.wnc","ratetables")
	}




"MyUseMethod" <-
function (generic, classobj = NULL) 
{ ## This probably isn't needed any more but I haven't got around to
  ## checking (TSL 25/8/97)
        call <- sys.call(sys.parent())
	if (is.null(classobj)) 
		classobj <- eval(call[[2]], sys.frame(sys.parent()))
	classlist <- class(classobj)
	classlist <- c(classlist, "default")
	while (!exists(paste(generic, classlist[[1]], sep = "."
	),mode="function",inherits=TRUE) && length(classlist) > 1) classlist <- classlist[-1]
        methodname<-paste(generic, classlist[[1]], sep = "."
	)
	if (!exists(methodname,mode="function",inherits=TRUE))
		stop("No method found")
	call[[1]] <- as.name(methodname)
	eval(call, sys.frame(-2))
}

delete.response<- function (termobj) 
	terms(reformulate(attr(termobj, "term.labels"), NULL),
		 specials = names(attr(termobj, "specials"))
		)

all.equal <- function(x,y){
	 as.logical(prod(as.numeric((abs(x-y)<.Machine$double.eps) || (is.na(x) && is.na(y)))))
}


"pmin" <- function (..., na.rm = FALSE) 
{
	elts <- list(...)
	minmm <- as.vector(elts[[1]])
	for (each in elts[-1]) {
		work <- cbind(minmm, as.vector(each))
		nas <- is.na(work)
		work[, 1][nas[, 1]] <- work[, 2][nas[, 1]]
		work[, 2][nas[, 2]] <- work[, 1][nas[, 2]]
		change <- work[, 1] > work[, 2]
		work[, 1][change] <- work[, 2][change]
		if (!na.rm) 
			work[, 1][nas[, 1] + nas[, 2] > 0] <- NA
		minmm <- work[, 1]
	}
	attributes(minmm)<-attributes(elts[[1]])
	minmm
}

"pmax" <- function (..., na.rm = FALSE) 
{
	elts <- list(...)
	maxmm <- as.vector(elts[[1]])
	for (each in elts[-1]) {
		work <- cbind(maxmm, as.vector(each))
		nas <- is.na(work)
		work[, 1][nas[, 1]] <- work[, 2][nas[, 1]]
		work[, 2][nas[, 2]] <- work[, 1][nas[, 2]]
		change <- work[, 1] < work[, 2]
		work[, 1][change] <- work[, 2][change]
		if (!na.rm) 
			work[, 1][nas[, 1] + nas[, 2] > 0] <- NA
		maxmm <- work[, 1]
	}
	attributes(maxmm)<-attributes(elts[[1]])
	maxmm
}



 sort.list<-function(...) order(...)

"[.formula"<-function(f,i,...){ 
  tt<-terms.formula(f)[i]
  attributes(tt)<-list(class="formula") 
  tt
}
"[.terms" <-
function (termobj, i) 
{
        resp <- if (attr(termobj, "response")) 
                termobj[[2]]
        else NULL
        newformula <- attr(termobj, "term.labels")[i]
        if (length(newformula) == 0) 
                newformula <- 1
        newformula <- reformulate(newformula, resp)
        terms(newformula, specials = names(attr(termobj, "specials")))
}

is.category <- function(x) inherits(x,"factor") || is.factor(x)

"model.matrix.default" <-
  function (formula, data, contrasts = NULL) 
{ 
  t <- terms(formula)
  if (missing(data)) 
    data <- eval(attr(t, "variables"), sys.frame(sys.parent()))
  contrastsL <- contrasts
  rm(contrasts)
  if (!is.null(contrastsL)) {
    namD <- names(data)
    if (!is.list(contrastsL)) 
      stop("invalid contrasts")
    if (is.null(namC <- names(contrastsL))) 
      stop("invalid contrasts argument")
    for (nn in namC) {
      if (is.na(ni <- match(nn, namD))) 
        warning(paste("Variable", nn, 
                      "absent, contrast ignored"))
      else contrasts(data[[ni]]) <- contrastsL[[nn]]
    }
  } 
  reorder<-match(as.character(attr(t,"variables"))[-1],names(data))
  if (any(is.na(reorder))) stop("invalid model frame in model.matrix()")
  data<-data[,reorder,drop=F]
  .Internal(model.matrix(t, data))
}
