% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSFD.R
\name{spanfill}
\alias{spanfill}
\title{Generate points to approximate the space spanned by the existing points}
\usage{
spanfill(X, bound = FALSE)
}
\arguments{
\item{X}{a matrix specifying the existing points}

\item{bound}{a binary variable indicating whether to bound the generated points to 0 to 1 in each dimension. If bound=TRUE, all the generated points will be projected to the unit hypercube. The default value is FALSE.}
}
\value{
a matrix of the generated points to approximate the space.
}
\description{
\code{spanfill} generates points to approximate a space based on existing points.
These approximate points can be used to find local fill distance in the space or be used as candidate points in active learning.
}
\details{
\code{spanfill} generates points to approximate the space spanned by the existing points. Details can be found in  Wang et al. (2024).
}
\examples{

X = matrix(runif(20), ncol=2)
spanfill_points = spanfill(X)
plot(spanfill_points, type='p')

}
\references{
Wang, Shangkun, Adam P. Generale, Surya R. Kalidindi, and V. Roshan Joseph. (2024). "Sequential designs for filling output spaces", Technometrics, 66, 65–76.
}
