% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{h_ASE_reg}
\alias{h_ASE_reg}
\title{The ASE-optimal bandwidth in the regression context.}
\usage{
h_ASE_reg(desx, y, rx)
}
\arguments{
\item{desx}{numerical vecror of design points,}

\item{y}{numerical vecror of data points corresponding to the design points \eqn{desx},}

\item{rx}{numerical vecror of the regression function values at \eqn{desx}.}
}
\value{
The ASE-optimal bandwidth (scalar).
}
\description{
Computing the ASE-optimal bandwidth for the Gaussian local linear regression estimator.
}
\details{
Computing the ASE-optimal bandwidth for the local linear estimator in the regression context. The ASE-optimal bandwidth is the global minimizer of the ASE function \code{\link{ASE_reg}}. This bandwidth is optimal for the data set at hand.
}
\examples{
\dontrun{
# Simulated example.
n=300
dx=runif(n)            #uniform design
regx=5*dx^10*(1-dx)^2+2.5*dx^2*(1-dx)^10
ydat=regx+rnorm(n,sd=1/250)
hase=round(h_ASE_reg(dx,ydat,regx),digits=4)
u=seq(0,1,len=1000)
fun=5*u^10*(1-u)^2+2.5*u^2*(1-u)^10
dev.new()
plot(dx,ydat,pch=20,cex=1.5,xlab="argument",ylab="function",cex.lab=1.7,cex.axis=1.7,
main="Function, data, and the ASE-optimal bandwidth",cex.main=1.5)
lines(u,fun,'l',lwd=3,col="blue")
legend(0,0.03,legend=paste("h_ASE=",hase),cex=1.8,bty="n")
legend(0.6,-0.002,legend=paste("n=",n),cex=2,bty="n")
}
}
\seealso{
\code{\link{ASE_reg}}, \code{\link{loclin}}.
}
