% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsr_simulate.R
\name{opsr_simulate}
\alias{opsr_simulate}
\title{Simulate Data from an OPSR Process}
\usage{
opsr_simulate(nobs = 1000, sigma = NULL, seed = NULL)
}
\arguments{
\item{nobs}{number of observations to simulate.}

\item{sigma}{the covariance matrix of the multivariate normal.}

\item{seed}{a single value, interpreted as an integer, or \code{NULL} passed to
\code{\link{set.seed}}.}
}
\value{
Named list:
\item{params}{ground truth parameters.}
\item{data}{simulated data (as observed by the researcher). See also 'Details' section.}
\item{errors}{error draws from the multivariate normal (as used in the latent
process).}
\item{sigma}{assumed covariance matrix (to generate \code{errors}).}
}
\description{
Simulates data from an ordered probit process and separate (for each regime)
OLS process where the errors follow a multivariate normal distribution.
}
\details{
Three ordinal outcomes are simulated and the distinct design matrices (\code{W} and
\code{X}) are used (if \code{W == X} the model is poorely identified). Variables \code{ys} and
\code{xs} in \code{data} correspond to the selection process and \code{yo}, \code{xo} to the outcome
process.
}
