% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querying.R
\name{and_query}
\alias{and_query}
\alias{or_query}
\alias{not_query}
\title{Create a combined filter}
\usage{
and_query(...)

or_query(...)

not_query(...)
}
\arguments{
\item{...}{Raw odata queries or query options.}
}
\description{
Create a combined filter
}
\details{
This function can be used with raw values or query options
\enumerate{
\item Raw odata queries
Raw OData can be passed as string.
It's the responsibility of the caller that the argument is valid syntax
and values are escaped.
\item Query options
Query options can be passed as named parameters.
}

Query options should be of the following form: \code{property.operator = value}
\itemize{
\item Property should be a property of the entity or individual.
\item Operation can have any of the following values:
\itemize{
\item eq Whether property is equal to value.
\item ne Whether property is not equal to value.
\item gt Whether property is greater than value.
\item ge Whether property is greater than or equal to value.
\item lt Whether property is lower than value.
\item le Whether property is lower than or equal to value.
\item has Whether property has value as enumeration property.
\item startswith Whether property starts with value.
\item endswith Whether property ends with value.
\item contains Whether property contains value.
}
\item Value should be a string, double or boolean
and will be escaped automatically.
}
}
\examples{
and_query("Column eq OtherColumn",
          FirstName.startswith = 'A',
          LastName.eq = 'Scott')

or_query("ExpireDate eq null",
         ExpireDate.lt = "2020-07-07")

not_query(or_query(Age.lt = 21, Age.gt = 65))

}
\seealso{
\url{https://docs.oasis-open.org/odata/odata/v4.0/errata03/os/complete/part2-url-conventions/}
}
