% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ods-PLM.R
\name{quantileknots}
\alias{quantileknots}
\title{Create knots at sample quantiles}
\usage{
quantileknots(x, nknots, boundstab)
}
\arguments{
\item{x}{a vector. The knots are at sample quantiles of x.}

\item{nknots}{number of knots}

\item{boundstab}{parameter for boundary stability. The default is 0. If
boundstab = 1, then nknots+2 knots are created and the first and last are
deleted. This mitigates the extra variability of regression spline
estimates near the boundaries.}
}
\value{
a vector of knots at sample quantiles of x.
}
\description{
\code{quantileknots} creates knots at sample quantiles
}
\examples{
library(ODS)

x <- c(1, 2, 3, 4, 5)
quantileknots(x, 3, 0)
}
