\name{Necklaces}
\alias{Necklaces}
\title{Necklaces}
\description{The function generates all the representatives of all the necklaces of length \code{n} over an alphabet of \code{m} consecutive non-negative integers.
}
\usage{
Necklaces(n=1, m=1, fn=1)
}
\arguments{
  \item{n}{positive integer: the length of the representatives}
  \item{m}{positive integer: the number of consecutive non-negative integers in the alphabet}
  \item{fn}{integer: the first value of the alphabet, the default is 1}
}
\details{
The function generates the list of all representatives of all necklaces having a fixed length \code{n} on the same alphabet, by default \code{{1,2,...,m}}.
The main block function is the \code{\link{fNecklaces}} function of the  \code{Necklaces} package, which is called repeatedly. The input parameters of the \code{\link{fNecklaces}} function are generated by using the \code{mKT} function of the \code{kStatistics} package. Indeed, given a multi-index \code{v}, that is a vector of non-negative integers, and a positive integer \code{n}, the \code{mKT} function  returns all the lists \code{(v1,...,vn)} of non-negative integer vectors, having the same length of the multi-index \code{v} and such that \code{v=v1+...+vn}. Here, the \code{mKT} function is used with the input vector 
having length \code{1} as well as the output vectors \code{v1,...,vn}, corresponding to the partitions of an integer with a fixed number of parts. As example,  the \code{mKT} function with input \code{(3,3)} generates the following result:
\tabular{l}{\cr
\code{[( 1 )( 1 )( 1 )]} \cr
\code{[( 0 )( 1 )( 2 )]} \cr
\code{[( 1 )( 0 )( 2 )]} \cr
\code{[( 1 )( 2 )( 0 )]} \cr
\code{[( 0 )( 2 )( 1 )]} \cr
\code{[( 2 )( 0 )( 1 )]} \cr
\code{[( 2 )( 1 )( 0 )]} \cr
\code{[( 0 )( 3 )( 0 )]} \cr
\code{[( 3 )( 0 )( 0 )]} \cr
\code{[( 0 )( 0 )( 3 )]} \cr
}

Each vector is a possible configuration and 
then passed  to the \code{\link{fNecklaces}} function to recover the corresponding necklace. For example \cr
\itemize{
\item the configuration \code{[( 1 )( 1 )( 1 )]} denotes the vector 
\code{[1,2,3]}; calling \code{fNecklaces(c(1,1,1))}, the representatives 
\code{[1,2,3]} and \code{[1,3,2]} are generated; \cr
\item the configuration \code{[( 0 )( 1 )( 2 )]} denotes the vector   \code{[2,3,3]}; calling \code{fNecklaces(c(0,1,2))}, the reprsentative \code{[2,3,3]} is generated \cr 
\item the configuration  \code{[( 1 )( 0 )( 2 )]} denotes the vector   \code{[1,3,3]}; calling \code{fNecklaces(c(1,0,2))}, the representative \code{[1,3,3]} is generated;
}
and so on. As last step, the union of all the outputs gives the expected result:\cr
\tabular{c}{
\code{[ 1 1 1 ], [ 1 1 2 ], [ 1 1 3 ], [ 1 2 2 ], [ 1 2 3 ], [ 1 3 2 ], 
      [ 1 3 3 ], [ 2 2 2 ], [ 2 2 3 ], [ 2 3 3 ], [ 3 3 3 ]}\cr}
that are  all the representatives of necklaces of length \code{3} on the alphabet \code{{1,2,3}}.
}

\value{\item{list}{the list containing all the representatives of all the necklaces of length \code{n} over an alphabet of \code{m} consecutive non-negative integers.} }


\references{

Di Nardo, E., and Guarino., G.  (2022) kStatistics: Unbiased Estimates of Joint Cumulant Products from the Multivariate Faa Di Bruno's Formula. The R journal - In press.  (\url{https://arxiv.org/abs/2206.15348})

Di Nardo, E., and Guarino., G.  (2022)  Necklaces and bracelets in R - (\url{https://arxiv.org/abs/2208.06855})

Flajolet, P., and Sedgewick, R. (2009) Analytic combinatorics. Cambridge University press.
}

\author{
Elvira Di Nardo \email{elvira.dinardo@unito.it},\cr 
Giuseppe Guarino \email{giuseppe.guarino@rete.basilicata.it}
}

\note{
The function calls the \code{\link{fNecklaces}} function in the \code{Necklaces} package and the \code{mKT} functions in the \code{kStatistics} package.
}


\seealso{
\code{\link{fNecklaces}},
\code{\link{LyndonW}},
\code{\link{sBruijn}}
}


\examples{
# Generate the list of all the representatives of all the necklaces 
# of length 4 over the alphabet {1,2}. 
Necklaces(4,2)  


# Generate the list of  all the representatives of all the necklaces 
# of length 5 over the alphabet {1,2,3}. 
Necklaces(5,3)  


# Generate the list of  all the representatives of all the necklaces 
# of length 5 over the alphabet {0,1,2}. 
Necklaces(5,3,0) 


}

% R KEYWORDS
\keyword{Necklaces}
\keyword{Bracelets}
\keyword{Lyndon words}
\keyword{de Bruijn sequences}

