#' Calculate Ecological NUE (ecoNUE)
#' @description
#' The product of N productivity and mean residency time (MRT).
#' Formula: ecoNUE = NP * MRT
#' @param NP Nitrogen Productivity Value.
#' @param MRT Mean Residency Time value.
#' @return A numeric vector of ecoNUE values.
#' @examples
#' NP <- c(10, 12)
#' MRT <- c(4, 5)
#' ecoNUE(NP, MRT)
#' @export
ecoNUE <- function(NP, MRT) {
  return(NP * MRT)
}