#' Calculate N Uptake Efficiency (NUpE)
#' @description
#' The percentage of available soil N that is utilized by the plant.
#' Formula: NUpE = (PlantN / (FertN + SoilN)) * 100
#' @param PlantN A numeric vector of values for plant N content.
#' @param SoilN A numeric value or vector for soil N content.
#' @param FertN A numeric value or vector for fertilizer N input.
#' @return A numeric vector of NUpE percentages.
#' @examples
#' PlantN <- c(3.0, 3.5, 3.8)
#' SoilN <- c(20, 20, 20)
#' FertN <- 50
#' NUpE(PlantN, SoilN, FertN)
#' @export
NUpE <- function(PlantN, SoilN, FertN) {
  denom <- FertN + SoilN
  if (any(denom == 0)) {
    stop("Total available N (FertN + SoilN) cannot be zero.")
  }
  return((PlantN / denom) * 100)
}