% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.include.best.R
\name{select.include.best}
\alias{select.include.best}
\title{NPI for selecting the subset including the best group}
\usage{
select.include.best(data, S)
}
\arguments{
\item{data}{a list of numeric data vectors}

\item{S}{a vector of indices of the groups in the data list to be considered as the subset of  groups that includes the best group.}
}
\value{
NPI lower and upper probabilities for the event that at least one of the next future observations from groups S is greater than all future observations from the other groups.
}
\description{
NPI lower and upper probabilities for the event that at least one
of the next future observations from groups S is greater than all
future observations from the other groups.
}
\examples{
# NPI lower and upper probabilities for the event that  at least one
# of the next future observations from groups S is greater than all
# future observations from the other groups.

data(FourSources)
# Convert the dataframe to a list of groups
data2<-split(FourSources$value,FourSources$source)
select.include.best(data2,S=c(1,3))
}
