% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norma_gene_core.R
\name{norma_gene_core}
\alias{norma_gene_core}
\title{NORMAgene core normalization engine}
\usage{
norma_gene_core(X, conditions = NULL)
}
\arguments{
\item{X}{A numeric matrix of raw ct values with replicates in rows and genes in columns.}

\item{conditions}{A vector of factors specifying experimental condition membership for replicates in the case of a multi-condition experiment, or \code{NULL} in the case of a single condition experiment. Normalization is applied within experimental conditions when specified, or across all replicates when \code{NULL}.}
}
\value{
A list with the following components:
\describe{
\item{norm}{A numeric matrix of normalized CT values with identical row and column order as \code{X}. Row and column names are inherited from \code{X}.}
\item{cor_fact}{A numeric vector of length \code{nrow(X)} containing the per-replicate scaling factors used for normalization. }
\item{rel_var}{A list containing relative variability metrics:
\describe{
\item{by_gene}{A named numeric matrix of gene-level relative variability values, calculated both within experimental conditions and cumulatively across all experimental conditions.}
\item{by_cond}{A named numeric vector of relative variability calculated within experimental conditions, as well as cumulatively across all experimental conditions, regardless of gene.}
}
}
}
}
\description{
Applies the least squares fit-based NORMAgene data-driven normalization algorithm originally described by Heckmann et al. (2011) to a matrix of raw CT values, and returns a list containing a matrix of normalized CT values along with associated scaling factors and relative variability metrics.
}
\details{
This function implements the core normalization and variance calculations and is primarily intended for internal use; most users should call \code{\link[=norma_gene]{norma_gene()}} instead. For more information on the NORMAgene algorithm or relative variability metrics, see \link{NORMAgene-package}.
}
\references{
Heckmann, LH., Sørensen, PB., Krogh, PH., & Sørensen, JG. (2011).
NORMA-Gene: a simple and robust method for qPCR normalization based on target gene data.
\emph{BMC Bioinformatics}, 12, 250.
\doi{10.1186/1471-2105-12-250}
}
\seealso{
\code{\link[=norma_gene]{norma_gene()}} \cr
\link{NORMAgene-package}
}
\keyword{internal}
