% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NORMAgene-package.R
\name{NORMAgene-package}
\alias{NORMAgene-package}
\title{Data-Driven qRT-PCR Normalization Using NORMAgene}
\description{
The 'NORMAgene' package enables normalization of raw quantitative reverse transcription polymerase chain reaction (qRT-PCR) crossing threshold (CT) values using the NORMAgene data-driven normalization algorithm originally described by Heckmann et al. (2011).  The NORMAgene algorithm uses within experimental condition least squares fits to estimate per-replicate technical variance and generate corresponding scaling factors that are ultimately applied for normalization. Normalization is reference gene agnostic, and can be carried out on data from as few as five target genes.
}
\details{
The primary user-facing function is \code{\link[=norma_gene]{norma_gene()}}, which is suitable for most standalone single experiment normalization workflows. \code{\link[=norma_gene]{norma_gene()}} applies the NORMAgene normalization algorithm to raw CT values provided via an input data frame appended with requisite experimental metadata. In addition to generating normalized CT values, the ratio of standard deviations-based relative variability metric originally described by Heckmann et al. (2011) is also calculated, both within target genes and experimental conditions, which users can employ to evaluate the effect of normalization on CT variability. This metric represents the proportional change in CT-value standard deviation pre to post normalization, with values of less than one indicating a reduction in variance as a result of normalization, and values of greater than one indicating an increase in variance as a result of normalization. The scaling factors applied for normalization can be accessed using \code{\link[=correction_factors]{correction_factors()}}, while relative variability metrics can be accessed using \code{\link[=relative_variability]{relative_variability()}}.

Note: \code{\link[=norma_gene_core]{norma_gene_core()}} provides matrix-based execution of the NORMAgene algorithm and is internally called by \code{\link[=norma_gene]{norma_gene()}}. While use of \code{\link[=norma_gene]{norma_gene()}} is recommended in a majority of situations, directly calling \code{\link[=norma_gene_core]{norma_gene_core()}} may afford advanced users a lightweight option for cleaner integration into larger post-analytical pipelines. \code{\link[=norma_gene_core]{norma_gene_core()}} is not exported and can only be called using the internal namespace operator.

Two real-world qPCR datasets are also included, which are used in the documentation examples. The dataset \link{multi_cond_data} contains raw CT values and experimental meta-data from a case-control comparison of whole blood gene expression in human ischemic stroke published by O’Connell et al. (2017). It can be used to demonstrate or evaluate normalization workflows for use-cases involving data from multiple experimental condition. The dataset \link{single_cond_data} contains raw CT values and experimental meta-data from a single cohort study of whole blood gene expression in human ischemic stroke published by O’Connell et al. (2017). It can be used to demonstrate or evaluate normalization workflows for use-cases involving data from a single experimental condition.
}
\section{Main functions}{

\describe{
\item{\code{\link[=norma_gene]{norma_gene()}}}{Normalize CT values stored in a data frame.}
\item{\code{\link[=relative_variability]{relative_variability()}}}{Extract relative variability metrics.}
\item{\code{\link[=correction_factors]{correction_factors()}}}{Extract per-replicate correction factors.}
}
}

\section{Datasets}{

\describe{
\item{\link{multi_cond_data}}{Example dataset from a real-world multi-condition experiment.}
\item{\link{single_cond_data}}{Example dataset from a real-world single condition experiment.}
}
}

\section{Citation}{

If you use the NORMAgene package in published work, please cite:

O'Connell, GC. (2024).
\emph{NORMAgene}.
R package version 0.1.1.
Available from \url{https://CRAN.R-project.org/package=NORMAgene}.
}

\references{
Heckmann, LH., Sørensen, PB., Krogh, PH., & Sørensen, JG. (2011).
NORMA-Gene: a simple and robust method for qPCR normalization based on target gene data.
\emph{BMC Bioinformatics}, 12, 250.
\doi{10.1186/1471-2105-12-250}

O'Connell, GC., Treadway, MB., Petrone, AB., Tennant, CS., Lucke-Wold, N, Chantler, PD., & Barr, TL. (2017).
Leukocyte dynamics influence reference gene stability in whole blood: Data-driven qRT-PCR normalization is a robust alternative for measurement of transcriptional biomarkers.
\emph{Laboratory Medicine}, 3, 48.
\doi{10.1093/labmed/lmx035}

O'Connell, GC., Treadway, MB., Petrone, AB., Tennant, CS., Lucke-Wold, N, Chantler, PD., & Barr, TL. (2017).
Peripheral blood AKAP7 expression as an early marker for lymphocyte-mediated post-stroke blood brain barrier disruption.
\emph{Scientific Reports}, 1, 7.
\doi{10.1038/s41598-017-01178-5}
}
\seealso{
\code{\link[=norma_gene]{norma_gene()}} \cr
\code{\link[=correction_factors]{correction_factors()}} \cr
\code{\link[=relative_variability]{relative_variability()}} \cr
\link{multi_cond_data} \cr
\link{single_cond_data}
}
