#' Print Method for NNMoMo Objects
#'
#' Method for printing the output of \code{\link{lcNN}}. Gives
#' fundamental infofmation about the object.
#'
#' @param x An object of class \code{NNMoMo}.
#' @param ... Further arguments passed to or from other methods.
#'
#' @return Prints basic information about the \code{NNMoMo} object to the
#' console.
#'
#' @export
print.NNMoMo <- function(x, ...) {
  cat(
    "NNMoMo object: a", x$loss_type, "neural network model of type",
    x$model_type, "with", x$activation, "activation\n"
  )
}
