% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_control_group.R
\name{diagnose_control_group}
\alias{diagnose_control_group}
\title{Diagnose control group}
\usage{
diagnose_control_group(nipt_control_group)
}
\arguments{
\item{nipt_control_group}{The NIPTControlGroup object to diagnose}
}
\value{
named list
}
\description{
Compute a regular Z-score for every chromosome of every sample in a NIPTControlGroup object
}
\details{
This function computes a regular Z-score for every chromosome of
every sample in a NIPTControlGroup object. It returns a named list with 
diagnostics information.

The function returns a named list with 3 fields:
\itemize{
\item \strong{Z_scores} A matrix containing Z-scores for every sample and every chromosome
\item \strong{abberant_scores} Dataframe with samplename and chromosome of Z-scores outside -3  3 range 
\item \strong{control_group_statistics} Matrix with mean, standard deviation and P value of Shapiro-Wilk test
}
}
\examples{
\dontrun{
diagnose_control_group(nipt_control_group = control_group)
}

}

