% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{MomCumZabs}
\alias{MomCumZabs}
\title{Moments and Cumulants of the Central Folded Normal Distribution}
\usage{
MomCumZabs(r, d, Type, nCum = FALSE)
}
\arguments{
\item{r}{The highest moment (cumulant) order.}

\item{d}{Integer; the dimension of the distribution. Must be 1 when `Type` is "Univariate" and greater than 1 when `Type` is "Multivariate".}

\item{Type}{Character; specifies the type of distribution. Must be either "Univariate" or "Multivariate".}

\item{nCum}{Logical; if TRUE, then cumulants are calculated.}
}
\value{
A list containing moments and optionally cumulants.
\itemize{
  \item For "Univariate" type:
    \itemize{
      \item \code{MuZ}: The moments of the univariate Central Folded Normal distribution.
      \item \code{CumZ}: The cumulants of the univariate Central Folded Normal distribution.
    }
  \item For "Multivariate" type:
    \itemize{
      \item \code{MuZ}: The moments of the d-variate Central Folded Normal distribution.
      \item \code{CumZ}: The cumulants of the d-variate Central Folded Normal distribution.
    }
}
}
\description{
Provides the theoretical moments and cumulants of the Central Folded Normal distribution.
Depending on the choice of `Type`, either the univariate or d-variate distribution is used.
}
\examples{
# Univariate case: The first three moments
MomCumZabs(3, 1, Type = "Univariate")
# Univariate case: The first three moments and cumulants
MomCumZabs(3, 1, Type = "Univariate",nCum = TRUE)
# d-variate case: The first three moments
MomCumZabs(3, 2, Type = "Multivariate" )
# d-variate case: The first three moments and cumulants
MomCumZabs(3, d=2, Type = "Multivariate",  nCum = TRUE)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021, Proposition 5.1 p.242 and formula: p. 301
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()}
}
\concept{Moments and cumulants}
