% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{Cum2Mom}
\alias{Cum2Mom}
\title{Convert cumulants to moments (univariate and multivariate)}
\usage{
Cum2Mom(cumulants, Type = c("Univariate", "Multivariate"))
}
\arguments{
\item{cumulants}{Either a vector of univariate cumulants or a list of vectors of multivariate cumulants.}

\item{Type}{A character string specifying the type of cumulants provided. Use "Univariate" for univariate cumulants and "Multivariate" for multivariate cumulants.}
}
\value{
The vector of moments if \code{Type} is "Univariate" or the list of vectors of moments if \code{Type} is "Multivariate".
}
\description{
Obtains a vector of moments from a vector of cumulants for either univariate or multivariate data.
}
\examples{
# Univariate example
cum_x <- c(1, 2, 3, 4)
Cum2Mom(cum_x, Type = "Univariate")

# Multivariate example
cum <- list(c(0,0), c(1,0,0,1), c(rep(0,8)), c(rep(0,16)), c(rep(0,32)))
Cum2Mom(cum, Type = "Multivariate")

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear, Springer 2021. Section 3.4.
}
\seealso{
Other Moments and cumulants: 
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
