% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBest.R
\name{getBest}
\alias{getBest}
\title{Select best-fitting model from a list of Latent Growth Models (LGM)}
\usage{
getBest(
  lgm_object,
  ic = c("BIC", "aBIC", "AIC", "CAIC", "AICC"),
  lrt = c("none", "aLRT", "BLRT"),
  p = 0.05
)
}
\arguments{
\item{lgm_object}{A list of LGM \code{mplusObject} to evaluate.}

\item{ic}{A character string specifying the information criterion (IC) to use for selecting the best-fitting model.
Supported options are Bayesian Information Criterion (BIC), sample-size-adjusted BIC (aBIC), Akaike Information Criterion (AIC),
Consistent Akaike Information Criterion (CAIC), and AIC corrected (AICC). The default is BIC.}

\item{lrt}{A character string specifying the likelihood ratio test (LRT) to use for selecting the best-fitting model.
Supported options are Bootstrap LRT (BLRT) and Lo-Mendel-Rubin adjusted LRT (aLRT).
Default is "none", the selection of the the best-fitting model is only made based on the selected IC.}

\item{p}{A numeric value specifying the p-value threshold for statistical significance when using LRT-based selection
of the best-fitting model. Default is 0.05.}
}
\value{
The LGM \code{mplusObject} of the best-fitting model.
}
\description{
Identify and extract the best-fitting model from a list of LGM
based on a specified set of criteria applied to a summary table of the models fit indices.
}
\details{
The function select the best-fitting model based on the following criteria:
\itemize{
\item 1. Models with convergence errors are excluded.
\item 2. The model with the lowest information criterion (IC) is selected.
\item 3. If specified, the likelihood ratio test (LRT) is used to determine whether the K-class model can be reduced to K-1 classes.
\item 4. The resulting model throw a warning if it meet any of the following conditions:
\itemize{
\item - Entropy is below 0.5.
\item - Any class has an average posterior probability of assignment (APPA) below 0.7.
\item - Any class represents less than 5\% of the sample size.
}
}
}
\examples{
\donttest{
# Example usage:
GBTM_best <- getBest(
  lgm_object = GBTM_models,
  ic = "BIC",
  lrt = "aLRT",
  p = 0.05
)

best_fit <- getFit(GBTM_best)

print(best_fit)
}
}
