% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.r
\name{find_path_to_tip}
\alias{find_path_to_tip}
\title{Determines the route (nodes and branches) for a tip in a phylogenetic tree}
\usage{
find_path_to_tip(tree, tip)
}
\arguments{
\item{tree}{A phylogenetic tree of class \code{phylo}}

\item{tip}{Tip label (character)}
}
\value{
A matrix with columns \code{parent} and \code{child} representing the path
}
\description{
Traverses the tree to determine the evolutionary path (branches) from root to a given tip.
}
\examples{
phy <- ape::rtree(10)
route_n <- find_path_to_tip(phy, "t2")
}
