% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_lme.R
\name{simulate.graph_lme}
\alias{simulate.graph_lme}
\title{Simulation of models on metric graphs}
\usage{
\method{simulate}{graph_lme}(
  object,
  nsim = 1,
  seed = NULL,
  sample_latent = FALSE,
  posterior = FALSE,
  which_repl = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{graph_lme} object}

\item{nsim}{The number of simulations.}

\item{seed}{an object specifying if and how the random number generator should be initialized ('seeded').}

\item{sample_latent}{If \code{FALSE}, samples for the response variable will be generated. If \code{TRUE}, samples for the latent model will be generated. The default is \code{FALSE}.}

\item{posterior}{Should posterior samples be generated? If \code{FALSE}, samples will be computed based on the estimated prior distribution. The default is \code{FALSE}.}

\item{which_repl}{Which replicates to generate the samples. If \code{NULL} samples will
be generated for all replicates. Default is \code{NULL}.}

\item{...}{Currently not used.}
}
\value{
A list containing elements \code{samples}, \code{edge_number} and \code{distance_on_edge}. Each of them is a list, whose indexes are the replicates, and in \code{samples} a matrix is given with \code{nsim} columns, each one being a sample. \code{edge_number} and \code{distance_on_edges} contain the respective edge numbers and distances on edge for each sampled element. The locations of the samples are the location of the data in which the model was fitted.
}
\description{
The function samples a Gaussian random field based on a
fitted model using \code{graph_lme()}.
}
