% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.wide.R
\name{to.long}
\alias{to.long}
\title{Functions to convert between long and wide representations of data}
\usage{
to.long(data, vars)
}
\arguments{
\item{data}{A \code{\link{Meth}} object.}

\item{vars}{The variables representing measurements by different methods. Either a character vector of names, or a numerical vector with the number of the variables in the dataframe.}
}
\value{
A data frame with the reshaped data
}
\description{
These functions are merely wrappers for \code{\link{reshape}}.
Given the complicated syntax of \code{reshape} and the particularly simple
structure of this problem, the functions facilitate the conversion
enormously.
}
\details{
If \code{data} represents method comparisons with exchangeable  replicates within method, the transformation to wide format does not necessarily make sense.
}
\examples{

data( milk )
str( milk )
mw <- to.wide( milk )
str( mw )
( mw <- subset( mw, as.integer(item) < 3 ) )
to.long( mw, 3:4 )

}
