% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful_functions.R
\name{read_test_data}
\alias{read_test_data}
\alias{read_test_data,MetaNLP-method}
\title{Read and adapt test data}
\usage{
read_test_data(object, ...)

\S4method{read_test_data}{MetaNLP}(object, file, ...)
}
\arguments{
\item{object}{The MetaNLP object created from the training data.}

\item{...}{Further arguments to \code{MetaNLP}.}

\item{file}{Either the path to the test data csv, the data frame containing
the papers or a MetaNLP object}
}
\value{
An object of class MetaNLP
}
\description{
This function takes a MetaNLP object (the training data) and the
test data. The function creates the document-term matrix from the test data
and matches the columns of the given training MetaNLP object with the columns
of the test document-term matrix. This means that columns, which do appear
in the test document-term matrix but not in the training document-term matrix are
removed; columns that appear in the training document-term matrix but not in the
test document-term matrix are added as a column consisting of zeros.
}
\examples{
path_train <- system.file("extdata", "test_data.csv", package = "MetaNLP", mustWork = TRUE)
path_test <- system.file("extdata", "test_data_changed.csv", package = "MetaNLP", mustWork = TRUE)
obj_train <- MetaNLP(path_train)
obj_test <- MetaNLP(path_test)
to_test_obj <- read_test_data(obj_train, obj_test)

}
