% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.HMM.R
\name{r.HMM}
\alias{r.HMM}
\title{Random Number Generation for Matrix-Variate Hidden Markov Models}
\usage{
r.HMM(density, num, t, PI, M, U, V, IP, nu, alpha, eta)
}
\arguments{
\item{density}{A character string specifying the distribution to use for the HMM.
Possible values are: "MVN" for the matrix-variate normal distribution, "MVT" for the matrix-variate t-distribution,
and "MVCN" for the matrix-variate contaminated normal distribution.}

\item{num}{An integer specifying the number of random matrices to generate.}

\item{t}{An integer specifying the number of time points.}

\item{PI}{A matrix representing the transition probability matrix.}

\item{M}{An array with dimensions \code{p} x \code{r} x \code{k}, where \code{k} is the number of states, containing the mean matrices.}

\item{U}{An array with dimensions \code{p} x \code{p} x \code{k}, where \code{k} is the number of states, containing the row covariance (scale) matrices.}

\item{V}{An array with dimensions \code{r} x \code{r} x \code{k}, where \code{k} is the number of states, containing the column covariance (scale) matrices.}

\item{IP}{A numeric vector of length \code{k} containing the initial probability weights.}

\item{nu}{A numeric vector of length \code{k} containing the degrees of freedom for each state in the MVT distribution.}

\item{alpha}{A numeric vector of length \code{k} containing the proportion of typical points in each state for the MVCN distribution.}

\item{eta}{A numeric vector of length \code{k} containing the inflation parameters for each state in the MVCN distribution.}
}
\value{
A list containing the following elements:
\item{Y}{An array with dimensions \code{p} x \code{r} x \code{num} x \code{t} containing the generated data.}
\item{obs.states}{An \code{num} x \code{t} matrix containing the state memberships.}
}
\description{
Generates random numbers for matrix-variate Hidden Markov Models (HMMs) based on matrix-variate normal, t, and contaminated normal distributions.
}
\examples{
p <- 2
r <- 3
num <- 50
t <- 3
k <- 2
IP <- c(0.5, 0.5)
PI <- matrix(c(0.9, 0.1, 0.3, 0.7), nrow = k, ncol = k, byrow = TRUE)
M <- array(NA, dim = c(p, r, k))
M[,,1]<- matrix(c(0,1,1,
                 -1,-1.5,-1),nrow = p, ncol = r, byrow = TRUE)
M[,,2]<- M[,,1]+3
U <- array(NA, dim = c(p, p, k))
V <- array(NA, dim = c(r, r, k))
U[, , 1] <- U[, , 2] <- matrix(c(1.73, -0.59, -0.59, 2.52), nrow = p, ncol = p, byrow = TRUE)
V[, , 1] <- V[, , 2] <- matrix(c(0.69, 0.23, -0.03,
                                 0.23, 0.48,  0.16,
                                -0.03, 0.16,  0.88), nrow = r, ncol = r, byrow = TRUE)
nu <- c(4.5, 6.5)
simData <- r.HMM(density = "MVT", num = num, t = t, PI = PI,
                M = M, U = U, V = V, IP = IP, nu = nu)
}
