% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotPath.R
\name{ggplotPath}
\alias{ggplotPath}
\title{\code{ggplot} paths}
\usage{
ggplotPath(
  x = "year",
  y,
  group,
  data,
  scaley = 1,
  logy = TRUE,
  ylab,
  legend.position,
  hlines,
  vlines,
  labels,
  fontsize = 10,
  color,
  linetype
)
}
\arguments{
\item{x}{name of column in \code{data} to pass as \code{x} in
\code{aes(x=.data[[x]], ...)}; default = \code{year}.}

\item{y}{name of column in \code{data} to pass as \code{y} in
\code{aes(y=.data[[y]], ...)}; must be supplied.}

\item{group}{name of grouping variable, i.e., plot a separate line for each
level of \code{group} using \code{aes(group=.data[[group]], ...)}, unless \code{group} is
missing or \code{length(unique(data[, group]))} = 1.}

\item{data}{\code{\link{data.frame}} or \code{\link[tibble:tibble]{tibble::tibble}} with columns \code{x}, \code{y}, and
\code{group}.}

\item{scaley}{factor to divide y by for plotting. Default = 1, but for data
in monetary terms, e.g., for \code{MaddisonData}, \code{y = 'gdppc'} is Gross domestic
product (GDP) per capita in 2011 dollars at purchasing power parity (PPP),
for which we typically want \code{scaley} = 1000.}

\item{logy}{logical: if \code{TRUE}, y axis is on a log scale; default = \code{TRUE}.`}

\item{ylab}{y axis label. Default =
\code{if(scaley==1) y else paste(y, '/', scaley)}}

\item{legend.position}{argument passed to \code{\link[ggplot2:theme]{ggplot2::theme}}. If \code{!missing(labels)},
default is no legend. Otherwise, default depends on
\verb{nGps <- length(unique(data[, group]}: If \code{nGps} = 1, there is no legend. If
\code{nGps > 10}, \code{legend.position = 'right'}. In between, \code{legend.position} =
c(.15, .5) = center left. For alternatives, see \code{\link[ggplot2:theme]{ggplot2::theme}}.}

\item{hlines}{numeric vector of locations on the \code{y} axis for horizontal
lines using \code{ggplot2::geom_hline(yintercept = hlines, ...)}
with \verb{color='grey', lty='dotted'} unless \code{color} or \code{colour} and / or \code{lty}
are available as \code{attr(x, ...)}.}

\item{vlines}{numeric vector of locations on the \code{x} axis for vertical lines
using \code{ggplot2::geom_vline(xintercept = vlines, ...)}
with \verb{color='grey', lty='dotted'} unless \code{color} or \code{colour} and / or \code{lty}
are available as \code{attr(x, ...)}.}

\item{labels}{= \code{\link{data.frame}} with columns \verb{x, y, label}, and optionally
\verb{srt, col, size}, where \code{x}, \code{y}, \code{srt}, and \code{size} are are numeric,
\code{label} is character, and \code{col} are acceptable values for \code{color} in
\code{with(labels, annotate('text', x=x, y=y, label = label, srt=srt,  color=col, size=size))}. Defaults for \code{srt}, \code{col}, and \code{size}  are 0,
'black', and 4, respectively.}

\item{fontsize}{for legend and axes labels in
theme(text=element_text(size=fontsize)); default = 10.}

\item{color}{for lines to pass to \code{scale_color_manual(values = color)} if
present. If present, \code{length(color)} should equal
\code{length(unique(data[, group]))}.}

\item{linetype}{optional vector. Default \verb{if(missing(group))} 1 else
\verb{rep(1:6, length=length(unique(data[, group]))}.
Else either
\itemize{
\item an integer (0-6), a name (0 = blank, 1 = solid, 2 = dashed,
3 = dotted, 4 = \code{dotdash}, 5 = \code{longdash}, 6 = \code{twodash}), or
\item a mapping to a discrete variable, or
\item a string of an even number (up to eight) of hexadecimal digits
which give the lengths in consecutive positions in the string.
}}
}
\value{
an object of class \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}, which can be subsequently
edited, and whose \code{\link{print}} method produces the desired plot.
}
\description{
\code{ggplotPath} plots \code{y} vs. \code{x} (typically \code{year}) with a separate line for
each group with options for legend placement, horizontal and vertical lines
and labels.
}
\examples{
str(GBR_USA <- subset(MaddisonData::MaddisonData, ISO \%in\% c('GBR', 'USA')))
GBR_USA1 <- MaddisonData::ggplotPath('year', 'gdppc', 'ISO', GBR_USA, 1000)

GBR_USA1+ggplot2::coord_cartesian(xlim=c(1500, 1850)) # for only 1500-1850 
GBR_USA1+ggplot2::coord_cartesian(xlim=c(1600, 1700), ylim=c(7, 17)) 

# label the lines
ISOll <- data.frame(x=c(1500, 1800), y=c(2.5, 1.7), label=c('GBR', 'USA'), 
              srt=c(0, 30), col=c('red', 'green'), size=c(2, 9))
GBR_USA2 <- ggplotPath('year', 'gdppc', 'ISO', GBR_USA, 1000, 
                    labels=ISOll, fontsize = 20)  
                        
# h, vlines, manual legend only 
Hlines <- c(1,3, 10, 30)
Vlines = c(1849, 1929, 1933, 1939, 1945)
(GBR_USA3 <- ggplotPath('year', 'gdppc', 'ISO', GBR_USA, 1000, 
       ylab='GDP per capita (2011 PPP K$)', 
       legend.position = NULL, hlines=Hlines, vlines=Vlines, labels=ISOll))  

}
\keyword{plot}
