% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madantextnetwork.r
\name{Community.Detection.Membership}
\alias{Community.Detection.Membership}
\title{Get Community Membership of a Graph}
\usage{
Community.Detection.Membership(network)
}
\arguments{
\item{network}{A graph object.}
}
\value{
A data frame where each row represents a node in the graph,
with columns for the node name and its corresponding community
membership number. This information is useful for understanding
the community structure within the graph.
}
\description{
This function applies community detection to a graph and returns the
membership information of each node.
}
\examples{
\dontrun{
  network <- make_graph("Zachary")
  membership_info <- Community.Detection.Membership(network)
  print(membership_info)
}
}
