% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.genome.plot.R
\name{smooth.genome.plot}
\alias{smooth.genome.plot}
\title{A Function for Plotting Smoothed Pearson Correlation Coefficients Across Multiple Chromosomes}
\usage{
smooth.genome.plot(plot.list, plot.column = "R^2", annot.colors = c("black",
  "red", "green", "blue", "cyan"), vert.pad = 0.05, ylim.low = NULL,
  ylim.high = NULL, plot.legend = TRUE, legend.loc = "bottomright",
  lty.vec = NULL, lwd.vec = NULL, loess.span = 250, expand.size = 50,
  rect.colors = c("light gray", "gray"), chr.label = TRUE,
  xaxis.label = "Chromosome", yaxis.label = NULL, main.label = NULL,
  axis.cex = 1, label.cex = 1, xaxis.line = 1.5, yaxis.line = 2.5,
  main.line = 0, margin.vec = rep(1, 4))
}
\arguments{
\item{plot.list}{A list produced by corr.list.compute().}

\item{plot.column}{"R" or "R^2" depending on whether Pearson correlation coefficients or squared Pearson
correlation coefficients will be plotted.  Default = "R^2".}

\item{annot.colors}{A vector of colors used for plotting values in different entries of plot.list.  Default = c("black", "red", "green", "blue", "cyan").}

\item{vert.pad}{Amount of vertical white space in the plot.  Default = 0.}

\item{ylim.low}{Smallest value on the y-axis (used to control the range of values on the y-axis).  Default = NULL.}

\item{ylim.high}{Largest value on the y-axis (used to control the range of values on the y-axis).  Default = NULL.}

\item{plot.legend}{Logical value specifying whether a legend should be included.  Default = FALSE.}

\item{legend.loc}{Character value specifing the location of the legend.  Default = "topright".  See See \code{\link{legend}}.}

\item{lty.vec}{Vector specifying line types for plotting values in different entries of plot.list.  Default = NULL.  See \code{\link{par}}.}

\item{lwd.vec}{Vector specifying line widths for plotting values in different entries of  plot.list.  Default = NULL.  See \code{\link{par}}.}

\item{loess.span}{A numerical value used to control the level of smoothing.  Smoothing is performed separately for each chromosome,
and loess.span effectively defines the number of genes in each smoothing window.  Default = 250.}

\item{expand.size}{A numerical value used to control smoothing at the ends of chromosomes.  Both ends of each chromosome are artificially
extended by expand.size genes, smoothing is performed on the expanded chromosome, and then the smoothed values are restricted to the size
    of the original chromosome.  Default = 50.}

\item{rect.colors}{A character vector of length two that controls the background color for each alternating chromosome.  Default = c("light gray", "gray").}

\item{chr.label}{Logical value specifying whether chromosome numbers should appear on the plot.  Default = FALSE.}

\item{xaxis.label}{Text used to label the x-axis of the plot.  Default = "Chromosome".  See \code{\link{plot}}.}

\item{yaxis.label}{Text used to label the y-axis of the plot.  Default = NULL.  See \code{\link{plot}}.}

\item{main.label}{Text used to label the plot header.  Default = NULL.  See \code{\link{par}}.}

\item{axis.cex}{Numerical value used to specify the font size on the axes.  Default = 1.  See \code{\link{par}}.}

\item{label.cex}{Numerical value used to specify the font size for the axis labels.  Default = 1.  See \code{\link{par}}.}

\item{xaxis.line}{Numerical value used to specify location of xaxis.label.  Default = 0.  See \code{\link{mtext}}.}

\item{yaxis.line}{Numerical value used to specify location of yaxis.label.  Default = 0.  See \code{\link{mtext}}.}

\item{main.line}{Numerical value used to specify location of main.label.  Default = 0.  See \code{\link{mtext}}.}

\item{margin.vec}{Numerical vector specifying margin sizes.  Default = rep(1, 4).  See \code{\link{par}}.}
}
\value{
Creates a plot of gene-level R or R^2 values produced by corr.list.compute().  Values of R
}
\description{
This function plots smoothed R or R^2 values produced by corr.list.compute() across multiple chromosomes or genomewide.
}
\examples{
exp.mat = tcga.exp.convert(exp.mat)

 cn.mat = tcga.cn.convert(cn.mat)

 prepped.data = data.prep(exp.mat, cn.mat, gene.annot, sample.annot, log.exp = FALSE)

 pd.exp = prepped.data[["exp"]]

 pd.cn = prepped.data[["cn"]]

 pd.ga = prepped.data[["gene.annot"]]

 pd.sa = prepped.data[["sample.annot"]]

 output.list = corr.list.compute(pd.exp, pd.cn, pd.ga, pd.sa)

 smooth.genome.plot(plot.list = output.list, lwd.vec = c(3, 3), lty.vec = c(1, 2))

}
