% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVIRank.R
\name{plotVIRank}
\alias{plotVIRank}
\title{Plot variable importance ranking}
\usage{
plotVIRank(
  MUVRclassObject,
  n,
  model = "min",
  cut,
  maptype = c("heatmap", "dotplot"),
  add_blank = 4,
  cextext = 1
)
}
\arguments{
\item{MUVRclassObject}{An MUVR class object only applied to PLS, RF not rdCVnet}

\item{n}{Number of top ranking variables to plot (defaults to those selected by MUVR2)}

\item{model}{Which model to choose ('min', 'mid' (default) or 'max')}

\item{cut}{Optional value to cut length of variable names to `cut` number of characters}

\item{maptype}{for rdCvnet dot plot or heat map}

\item{add_blank}{put more blank when the rownames is too long,}

\item{cextext}{the cex of the text}
}
\value{
Barplot of variable rankings (lower is better)
}
\description{
Plot variable importance ranking in MUVR object. Regardless of MV core method, variables are sorted by rank, where lower is better.
`plotVIRank` produces boxplots of variable rankings for all model repetitions.
}
\examples{
\donttest{
data("freelive2")
nRep <- 2
nOuter <- 4
varRatio <-0.6
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                  nOuter = nOuter,
                   varRatio = varRatio,
                   method = "PLS",
                   modReturn = TRUE)
plotVIRank(regrModel, n=20)
}
}
