% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPCA.R
\name{plotPCA}
\alias{plotPCA}
\title{PCA score plot}
\usage{
plotPCA(pca, PC1 = 1, PC2 = 2, file, colVar, symbVar, main = "")
}
\arguments{
\item{pca}{A `prcomp` object}

\item{PC1}{Principal component on x-axis}

\item{PC2}{Principal component on y-axis}

\item{file}{If specified provides the name of a png export file. Otherwise normal plot.}

\item{colVar}{Continuous variable for coloring observations (40 cuts)}

\item{symbVar}{Categorical/discrete variable for multiple plot symbols}

\item{main}{If provided provides a main title of the plot}
}
\value{
A PCA score plot. Exported as png if `file` specified in function call.
}
\description{
Customised PCA score plots with the possibility to choose PCs, exporting to png and the possibility to add color or different plotting symbols according to variable.
}
\examples{
data("freelive2")
pca_object<-prcomp(XRVIP2)
plotPCA(pca_object)
}
