% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNormTest.R
\name{meanTest.multi}
\alias{meanTest.multi}
\title{Multiple Mean Vectors Hypothesis Testing}
\usage{
meanTest.multi(X, label, alpha = 0.05, verbose = TRUE)
}
\arguments{
\item{X}{The data matrix which is a matrix or data frame.}

\item{label}{A vector of group labels.}

\item{alpha}{The significance level. Default is 0.05.}

\item{verbose}{A boolean value. Default is TRUE. If TRUE, the null hypothesis will be displayed. If FALSE, the test will be carried out silently.}
}
\value{
An object of class "testResult", which is a list with the following elements:
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMeanT}{The sample mean.}
\item{SampMeanWithin}{The sample mean of each group.}
\item{SdTotal}{The total sample deviation.}
\item{SdBetween}{The sample deviation between group.}
\item{SdWithin}{The sample deviation of each group.}
\item{SdWithinT}{The sample deviation within group.}
\item{Df}{The degree of freedom.}
\item{sampleSize}{The sample size of each group.}
}
\description{
Test whether the mean vectors of multiple multivariate normal populations are all equal when the covariance matrices are equal. Suppose we have k populations, the null hypothesis is that "H0: mu1 = mu2 = ... = muk". There are two approximations (Bartlett's chi2 and Rao's F) to compute the p-value and the critical value. The realized value of the Wilks Lambda statistic and its degrees of freedom are also provided. If you want to perform an exact test, consult the Wilks Lambda statistic quantile table yourself, depending on the realized value of the statistic and its degrees of freedom.
}
\examples{
data(iris)
chart <- iris[, 1:4]
species <- iris[, 5]
# carry out the test
test1 <- meanTest.multi(chart, species)
test2 <- meanTest.multi(chart, species, verbose = FALSE)
# get the elements
test1$Stat
test1$SampMeanT
test1$sampleSize
}
\references{
Huixuan, Gao. Applied Multivariate Statistical Analysis. Peking University Press, 2005: pp.80-83.
}
\author{
Xifeng Zhang
}
