% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrtPV.R
\name{lrtPV}
\alias{lrtPV}
\title{Likelihood Ratio Test with Model Results Using Plausible Values}
\usage{
lrtPV(mf, mr)
}
\arguments{
\item{mf}{The full model object fit using mixPV.}

\item{mr}{The reduced model object fit using mixPV.}
}
\description{
Compares two nested models (a full and a reduced model). Results in an F statistic (not the traditional chi-square) with a p-value (see Huang, 2024).
The full model must come first. Statistically significant results indicate that the full model
fits better than the reduced model. Uses computations shown by Li et al. (1991).
}
\examples{
\dontrun{
data(pisa2012, package = 'MLMusingR')
reduced <- mixPV(pv1math + pv2math + pv3math + pv4math + pv5math ~
 escs + (1|schoolid), data = pisa2012,
 weights = c('w_fstuwt', 'w_fschwt'))
full <- mixPV(pv1math + pv2math + pv3math + pv4math + pv5math ~
 escs + (escs|schoolid), data = pisa2012,
 weights = c('w_fstuwt', 'w_fschwt'))
lrtPV(full, reduced)
}

}
\references{
\cite{Huang, F. (2024). Using plausible values when fitting multilevel models with large-scale assessment data using R. Large-scale Assessments in Education, 12(7).
(\href{https://largescaleassessmentsineducation.springeropen.com/articles/10.1186/s40536-024-00192-0}{link})}

\cite{Li, K. H., Meng, X.L., Raghunathan, T. E., & Rubin, D. B. (1991). Significance levels from repeated p-values with multiply imputed data. Statistica Sinica, 65–92.
}
}
