% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{preproc_MFPCA}
\alias{preproc_MFPCA}
\title{Preprocessing step to create MFPCA object}
\usage{
preproc_MFPCA(
  data,
  uni_mean = "y ~ s(obstime) + s(x2)",
  time = "obstime",
  id = "id",
  marker = "marker",
  M = NULL,
  weights = FALSE,
  remove_obs = NULL,
  method = c("fpca", "fpca.sc", "FPCA", "PACE"),
  nbasis = 10,
  nbasis_cov = nbasis,
  bs_cov = "symm",
  npc = NULL,
  fve_uni = 0.99,
  pve_uni = 0.99,
  fit = FALSE,
  max_time = NULL,
  save_uniFPCA = FALSE,
  save_uniGAM = FALSE
)
}
\arguments{
\item{data}{Data.frame such as returned by function simMultiJM.}

\item{uni_mean}{String to crate a formula for the univariate addtive models.}

\item{time}{String giving the name of the longitudinal time variable.}

\item{id}{String giving the name of the identifier.}

\item{marker}{String giving the name of the longitudinal marker variable.}

\item{M}{Number of mFPCs to compute in the MFPCA. If not supplied, it
defaults to the maximum number of computable mFPCs.}

\item{weights}{TRUE if inverse sum of univariate eigenvals should be used as
weights in the scalar product of the MFPCA. Defaults to FALSE (weights 1).}

\item{remove_obs}{Minimal number of observations per individual and marker to
be included in the FPC estimation. Defaults to NULL (all observations). Not
removing observations can lead to problems if the univariate variance
estimate is negative and has to be truncated, then the scores for IDs with
few observations cannot be estimated.}

\item{method}{Which package to use for the univariate FPCA. Either function
adapted function 'fpca', 'FPCA' from package \code{fdapace}, 'fpca.sc' from
package \code{refund}, or function 'PACE' from package \code{MFPCA}.}

\item{nbasis}{Number of B-spline basis functions for mean estimate for
methods fpca, fpca.sc, PACE. For fpca.sc, PACE also bivariate smoothing of
covariance estimate.}

\item{nbasis_cov}{Number of basis functions used for the bivariate
smoothing of the covariance surface for method fpca.}

\item{bs_cov}{Type of spline for the bivariate smoothing of the covariance
surface for method fpca. Default is symmetric fast covariance smoothing
proposed by Cederbaum.}

\item{npc}{Number of univariate principal components to use in fpca.sc, PACE.}

\item{fve_uni}{Fraction of univariate variance explained for method FPCA.}

\item{pve_uni}{Proportion of univariate variance explained for methods
fpca, fpca.sc, PACE.}

\item{fit}{MFPCA argument to return a truncated KL fit to the data. Defaults
to FALSE.}

\item{max_time}{If supplied, forces the evaluation of the MFPCs up to maxtime.
Only implemented for method = 'fpca'.}

\item{save_uniFPCA}{TRUE to attach list of univariate FPCAs as attribute to
output. Defaults to FALSE.}

\item{save_uniGAM}{TRUE to attach list of univariate additive models used to
calculate the residuals. Defaults to FALSE.}
}
\value{
An object of class \code{MFPCAfit} with additional attributes
 depending on the arguments \code{save_uniFPCA}, \code{save_uniGAM},
 \code{fit}.
}
\description{
This function takes the data und uses the residuals of marker-specific
additive models to estimate the covariance structure for a MFPCA
}
\examples{
data(pbc_subset)
mfpca <- preproc_MFPCA(pbc_subset, uni_mean = paste0(
    "logy ~ 1 + sex + drug + s(obstime, k = 10, bs = 'ps') + ",
    "s(age, k = 10, bs = 'ps')"),
    pve_uni = 0.99, nbasis = 5, weights = TRUE, save_uniFPCA = TRUE)
}
