% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_power.R
\name{chi_power}
\alias{chi_power}
\title{Power Estimation of Chi Square Tests}
\usage{
chi_power(
  pnull,
  ralt,
  param_alt,
  phat = function(x) -99,
  alpha = 0.05,
  Ranges = matrix(c(-Inf, Inf, -Inf, Inf), 2, 2),
  nbins = c(5, 5),
  rate = 0,
  minexpcount = 5,
  dnull = function(x) -99,
  Retry = TRUE,
  SuppressMessages = TRUE,
  B = 1000
)
}
\arguments{
\item{pnull}{distribution function to find cdf under  null hypothesis}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{phat}{=function(x) -99, function to estimate parameters}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{Ranges}{=matrix(c(-Inf, Inf, -Inf, Inf),2,2), a 2x2 matrix with lower and upper bounds, if any}

\item{nbins}{=c(5, 5), number of bins for chi square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{minexpcount}{=5 minimal expected bin count required}

\item{dnull}{=function(x) -99, density function to find probabilities under null hypothesis, mostly used for discrete data, or -99 if missing.}

\item{Retry}{=TRUE, retry if test fails?}

\item{SuppressMessages}{=TRUE, should info be shown?}

\item{B}{=1000 number of simulation runs to find power}
}
\value{
A numeric matrix of power values.
}
\description{
This function finds the power of various chi-square tests.
}
