% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{plot.spheremap}
\alias{plot.spheremap}
\title{Produces diagnostic plots for the estimated map using \code{\link{calc.maps.sphere}}.}
\usage{
\method{plot}{spheremap}(x, displaytext = TRUE, ...)
}
\arguments{
\item{x}{Map object from \code{\link{calc.maps.sphere}}}

\item{displaytext}{Logical argument determining how markers should be labelled in the MDS 
configuration plot. If TRUE then marker names are used. If FALSE then numbers are used.}

\item{...}{Further arguments are ignored. (accepted for compatibility with generic plot)}
}
\description{
Produces diagnostic plots for the estimated map using \code{\link{calc.maps.sphere}}.
}
\details{
Produces a figure with 3 panels from a map object produced by \code{\link{calc.maps.sphere}}.

Panel one shows the stress of the unconstrained MDS, the stress of the constrained 
MDS and the ratio of the two. A good rule of thumb is the stress from the constrained 
MDS should not be more than 10% higher than the stress of the unconstrained MDS.

Panel 2 shows the final configuration of the unconstrained MDS which can be used to 
identify outliers.

Panel 3 shows the final configuration of the constrained MDS in black and the 
unconstrained MDS in red. This can be used to check that the constrained fit 
is not distorting the data - large changes in the rank of a point in either 
dimension 1 or dimension 2 are indications of a problem with the fit.

Panel 4 shows the pointwise nearest neighbour fits in order of the position 
in the estimated map.

If \code{D1lim} or \code{D2lim} is not specified, then limits of panels 2 and 
3 are defined by \code{\link[smacof]{plot.smacof}}. 

Markers are assigned numbers according to the order in which they occur in the 
input file. The locikey output of the map object is a data frame associating 
marker names with their numbers. This can be accessed using \code{pcmap3d$locikey}. 
If \code{displaytext=FALSE} then in panels 2 and 3 markers will be labelled by 
these numbers. By default \code{displaytext=TRUE} and markers are labelled by 
marker name.
}
\examples{
map<-calc.maps.sphere(system.file("extdata", "lgI.txt", package="MDSMap"),
weightfn='lod', mapfn='kosambi')
plot(map)
}
\references{
\cite{de Leeuw J, Mair P (2009) Multidimensional scaling using majorization: SMACOF in R. J Stat Softw 31: 1-30} \url{https://www.jstatsoft.org/v31/i03/}
}
\seealso{
\code{\link{plot.pcmap}}, \code{\link{plot.pcmap3d}}, \code{\link[smacof]{plot.smacof}}, \code{\link{calc.maps.sphere}}
}
