% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringLC.R
\name{LocalControlClassic}
\alias{LocalControlClassic}
\title{Local Control Classic}
\usage{
LocalControlClassic(
  data,
  clusterVars,
  treatmentColName,
  outcomeColName,
  faclev = 3,
  scedas = "homo",
  clusterMethod = "ward",
  clusterDist = "euclidean",
  clusterCounts = c(50, 100, 200)
)
}
\arguments{
\item{data}{The data frame containing all baseline X covariates.}

\item{clusterVars}{List of names of X variable(s).}

\item{treatmentColName}{Name of treatment factor variable.}

\item{outcomeColName}{Name of outcome Y variable.}

\item{faclev}{Maximum number of different numerical values an outcome variable can assume
without automatically being converted into a "factor" variable; faclev=1 causes a binary
indicator to be treated as a continuous variable determining an average or proportion.}

\item{scedas}{Scedasticity assumption: "homo" or "hete".}

\item{clusterMethod}{Type of clustering method, defaults to "complete". Currently implemented methods:  "ward", "single", "complete" or "average".}

\item{clusterDist}{Distance type to use, defaults to "euclidean". Currently implemented: "euclidiean", "manhattan", "maximum", or "minkowski".}

\item{clusterCounts}{A vector containing different number of clusters in baseline X-covariate space which Local Control will iterate over.}
}
\value{
Returns a list containing several elements.
  \item{hiclus}{Name of clustering object created by UPShclus().}
  \item{dframe}{Name of data.frame containing X, t & Y variables.}
  \item{trtm}{Name of treatment factor variable.}
  \item{yvar}{Name of outcome Y variable.}
  \item{numclust}{Number of clusters requested.}
  \item{actclust}{Number of clusters actually produced.}
  \item{scedas}{Scedasticity assumption: "homo" or "hete"}
  \item{PStdif}{Character string describing the treatment difference.}
  \item{nnhbindf}{Vector containing cluster number for each patient. }
  \item{rawmean}{Unadjusted outcome mean by treatment group.}
  \item{rawvars}{Unadjusted outcome variance by treatment group.}
  \item{rawfreq}{Number of patients by treatment group.}
  \item{ratdif}{Unadjusted mean outcome difference between treatments.}
  \item{ratsde}{Standard error of unadjusted mean treatment difference.}
  \item{binmean}{Unadjusted mean outcome by cluster and treatment.}
  \item{binvars}{Unadjusted variance by cluster and treatment.}
  \item{binfreq}{Number of patients by bin and treatment.}
  \item{awbdif}{Across cluster average difference with cluster size weights.}
  \item{awbsde}{Standard error of awbdif.}
  \item{wwbdif}{Across cluster average difference, inverse variance weights.}
  \item{wwbsde}{Standard error of wwbdif.}
  \item{faclev}{Maximum number of different numerical values an outcome variable can assume without
   automatically being converted into a "factor" variable; faclev=1 causes a binary indicator to be
   treated as a continuous variable determining an average or proportion.}
  \item{youtype}{"continuous" => only next eight outputs; "factor" => only last three outputs.}
  \item{aovdiff}{ANOVA summary for treatment main effect only.}
  \item{form2}{Formula for outcome differences due to bins and to treatment nested within bins.}
  \item{bindiff}{ANOVA summary for treatment nested within cluster.}
  \item{sig2}{Estimate of error mean square in nested model.}
  \item{pbindif}{Unadjusted treatment difference by cluster.}
  \item{pbinsde}{Standard error of the unadjusted difference by cluster.}
  \item{pbinsiz}{Cluster radii measure: square root of total number of patients.}
  \item{symsiz}{Symbol size of largest possible Snowball in a UPSnnltd() plot with 1 cluster.}
  \item{factab}{Marginal table of counts by Y-factor level and treatment.}
  \item{cumchi}{Cumulative Chi-Square statistic for interaction in the three-way, nested table.}
  \item{cumdf}{Degrees of-Freedom for the Cumulative Chi-Squared.}
}
\description{
LocalControlClassic was originally contained in the deprecated
CRAN package USPS, this function is a combination
of three of the original USPS functions, UPShclus, UPSaccum, and UPSnnltd.
This replicates the original implementation of the Local Control functionality in
Robert Obenchain's USPS package. Some of the features have been
removed due to deprecation of R packages distributed through CRAN.
For a given number of patient clusters in baseline X-covariate space, LocalControlClassic()
characterizes the distribution of Nearest Neighbor "Local Treatement Differences" (LTDs) on
a specified Y-outcome variable.
}
\examples{
 data(lindner)

 cvars <- c("stent","height","female","diabetic","acutemi",
            "ejecfrac","ves1proc")
 numClusters <- c(1, 2, 10, 15, 20, 25, 30, 35, 40, 45, 50)
 results <- LocalControlClassic( data = lindner,
                                clusterVars = cvars,
                                treatmentColName = "abcix",
                                outcomeColName = "cardbill",
                                clusterCounts = numClusters)
 UPSLTDdist(results,ylim=c(-15000,15000))

}
\references{
\itemize{
 \item Obenchain, RL. \emph{USPS package: Unsupervised and Supervised Propensity Scoring in R.} \url{https://cran.r-project.org/src/contrib/Archive/USPS/} 2005.
 \item Obenchain, RL. \emph{The ''Local Control'' Approach to Adjustment for Treatment Selection Bias and Confounding (illustrated with JMP Scripts)}. Observational Studies. Cary, NC: SAS Press. 2009.
 \item Obenchain RL. The local control approach using JMP. In: Faries D, Leon AC, Haro JM, Obenchain RL, eds. Analysis of Observational Health Care Data Using SAS. Cary, NC: SAS Institute; 2010:151-194.
 \item Obenchain RL, Young SS. Advancing statistical thinking in observational health care research. J Stat Theory Pract. 2013;7(2):456-506.
 \item Faries DE, Chen Y, Lipkovich I, Zagar A, Liu X, Obenchain RL. Local control for identifying subgroups of interest in observational research: persistence of treatment for major depressive disorder. Int J Methods Psychiatr Res. 2013;22(3):185-194.
 \item Lopiano KK, Obenchain RL, Young SS. Fair treatment comparisons in observational research. Stat Anal Data Min. 2014;7(5):376-384.
 \item Young SS, Obenchain RL, Lambert CG (2016) A problem of bias and response heterogeneity. In: Alan Moghissi A, Ross G (eds) Standing with giants: A collection of public health essays in memoriam to Dr. Elizabeth M. Whelan. American Council on Science and Health, New York, NY, pp 153-169.
 }
}
