% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateGrid.R
\name{updateGrid}
\alias{updateGrid}
\title{This function updates the coordinate of each lobster at each timestep,}
\usage{
updateGrid(
  Lobster,
  Trap,
  trapCatch,
  lobSize,
  lobSex,
  radiusOfInfluence,
  currentZoI,
  dStep,
  howClose,
  q0,
  qmin,
  saturationThreshold,
  trapSaturation,
  lengthBased,
  lobLengthThreshold,
  sexBased
)
}
\arguments{
\item{Lobster}{is the x & y coordinates of each lobster}

\item{Trap}{is the x & y coordinates of the trap}

\item{trapCatch}{number of trapped lobster}

\item{lobSize}{Size of trapped lobster}

\item{lobSex}{Sex of trapped lobster}

\item{radiusOfInfluence}{is the initial radius of influence}

\item{currentZoI}{is the bait's area of influence at each timestep}

\item{dStep}{is how much a lobster moves in each time step}

\item{howClose}{The area within which a lobster considered trapped}

\item{q0}{is the initial probability of entry into an empty trap}

\item{qmin}{is the asymptotic minimum probability of entry}

\item{saturationThreshold}{is the number of lobsters in a trap at which the probability of
another lobster entering the trap is zero}

\item{trapSaturation}{Logical. If TRUE, lobsters behavioral interaction is included during the simulation.}

\item{lengthBased}{Logical. If TRUE, lobster size is taken into account}

\item{lobLengthThreshold}{is a size threshold (Carapace Length in mm), if a lobster larger than this threshold caught there will be no more entry to the trap}

\item{sexBased}{Logical. If TRUE, lobster sex is taken into account and user must provide a list containing sex distribution for the simulated population}
}
\value{
a list of new coordinates, number of catch and their sizes
}
\description{
This function updates the coordinate of each lobster at each timestep,
}
