% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screening.R
\name{screening}
\alias{screening}
\title{Screening of background or confounding components}
\usage{
screening(
  ldo,
  method = c("bf", "levene", "bartlett"),
  alpha = 0.05,
  criteria = c(1, 1)
)
}
\arguments{
\item{ldo}{Longitudinal Data Object}

\item{method}{list of tests to perform, standard values: 'bf', 'levene' or 'bartlett'). 'bf' relates to "Brown-Forsythe" Levene-type procedure, 'levene' uses classical "Levene's" procedure and 'bartlett' applies Bartlett's test.}

\item{alpha}{A numeric value to defining the cutoff to select peaks.}

\item{criteria}{indicators which criteria to use for screening decision.}
}
\value{
Returns an object of type 'LDOscreening' containing the original 'ldo' object and the results of the screening. The variable 'selectedPeaks' contains a matrix including the results (TRUE = Significant, FALSE = not Significant) of the specified tests ('bf', 'levene', 'bartlett').
}
\description{
Background noise signals originating from experimental settings or random events can hugely influence the signal pattern of the breath. Background data enables the detailed evaluation and differentiation of the compounds originating primarily from the background or confounding factors as compared to those from the sample itself. The method assumes that all compounds of interest show a larger variation in the sample as compared to the background noise.
}
\examples{
\dontrun{
} 

  data(LoBraExample)
  method= c('bf', 'levene', 'bartlett')
  alpha =0.05
  criteria=c(1,1)
  ldos<-screening(ldo, method, alpha, criteria)
  components <- ldos@selectedPeaks[,"levene"]
  components <- names(components)[components]
  selectedLDO <- selectComponents(ldo, components)


}
