% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalized_nested_Gibbs_wrappers.R
\name{penalized_nested_Gibbs}
\alias{penalized_nested_Gibbs}
\title{Penalized nested Gibbs sampler for Bayesian linear regression}
\usage{
penalized_nested_Gibbs(
  vy,
  mX,
  penalty_type = c("lasso", "horseshoe"),
  a,
  b,
  u,
  v,
  nsamples,
  lambda_init = 1,
  va_init = NULL,
  verbose = max(1L, floor(as.integer(nsamples)/10)),
  lower = 1e-12,
  upper = 5000,
  s_beta = 1L,
  s_siglam = 1L
)
}
\arguments{
\item{vy}{Numeric response vector of length \eqn{n}.}

\item{mX}{Numeric design matrix of dimension \eqn{n \times p}.}

\item{penalty_type}{Character string: either \code{"lasso"} or \code{"horseshoe"}.}

\item{a, b}{Hyperparameters for the inverse-gamma prior on \eqn{\sigma^2}.}

\item{u, v}{Hyperparameters for the prior on \eqn{\lambda^2}.}

\item{nsamples}{Integer number of outer MCMC iterations.}

\item{lambda_init}{Initial value for \eqn{\lambda}.}

\item{va_init}{Optional initial values for the local shrinkage parameters
(length \eqn{p}). If \code{NULL}, a vector of ones is used.}

\item{verbose}{Print progress every \code{verbose} iterations (0 = silent).}

\item{lower, upper}{Bounds for the slice sampler used for \eqn{\lambda^2}.}

\item{s_beta}{Integer: number of inner updates of \eqn{\beta} per outer iteration.}

\item{s_siglam}{Integer: number of inner updates of \eqn{(\sigma^2,\lambda^2)}
per \eqn{\beta} update.}
}
\value{
A list with components:
\describe{
  \item{mBeta}{Matrix of sampled \eqn{\beta} draws (rows correspond to stored draws).}
  \item{vsigma2}{Vector of sampled \eqn{\sigma^2} draws.}
  \item{vlambda2}{Vector of sampled \eqn{\lambda^2} draws.}
}

\code{lm_penalized_nested_gibbs()}.
}
\description{
Runs the nested Gibbs sampler for a Gaussian linear model
\eqn{y = X\beta + \epsilon} with either a lasso or horseshoe penalty
(shrinkage prior) on \eqn{\beta}. The algorithm supports both \eqn{n \ge p}
and \eqn{p > n} regimes.
}
\examples{
set.seed(1)
n <- 50; p <- 10
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

out <- penalized_nested_Gibbs(
  vy = y, mX = X,
  penalty_type = "lasso",
  a = 1, b = 1, u = 1, v = 1,
  nsamples = 200,
  lambda_init = 1,
  va_init = NULL,
  verbose = 0,
  lower = 1e-12,
  upper = 5000,
  s_beta = 1,
  s_siglam = 1
)
str(out)

}
