% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_custom_agent.R
\name{save_mermaid_png}
\alias{save_mermaid_png}
\title{Save Mermaid Diagram as PNG}
\usage{
save_mermaid_png(
  x,
  file,
  mmdc = Sys.which("mmdc"),
  direction = c("TD", "LR"),
  subgraphs = NULL,
  include_start_end = TRUE,
  style = TRUE,
  width = NULL,
  height = NULL,
  scale = NULL,
  background = "white",
  theme = "default",
  quiet = TRUE
)
}
\arguments{
\item{x}{Mermaid text, graph spec, or compiled object returned by
[build_custom_agent()] with `output = "both"` or [compile_graph()].}

\item{file}{Output `.png` path.}

\item{mmdc}{Path to Mermaid CLI executable. Defaults to `Sys.which("mmdc")`.}

\item{direction}{Mermaid direction used when `x` is not plain Mermaid text.}

\item{subgraphs}{Optional named list of subgraph groupings.}

\item{include_start_end}{Logical; include `__start__` and `__end__` nodes.}

\item{style}{Logical; include default Mermaid class styling.}

\item{width}{Optional diagram width passed to `mmdc`.}

\item{height}{Optional diagram height passed to `mmdc`.}

\item{scale}{Optional diagram scale passed to `mmdc`.}

\item{background}{Background color for Mermaid rendering.}

\item{theme}{Mermaid theme (for example `"default"`, `"neutral"`, `"dark"`).}

\item{quiet}{Logical; suppress Mermaid CLI output when `TRUE`.}
}
\value{
Invisibly returns the output file path.
}
\description{
Render Mermaid text (or a compiled graph object) to a PNG file using
Mermaid CLI (`mmdc`).
}
