% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRT.test.R
\name{LRT.test}
\alias{LRT.test}
\title{Likelihood Ratio Test}
\usage{
LRT.test(object1, object2)
}
\arguments{
\item{object1}{Fitted model object with fewer parameters (i.e., fewer \code{npar}, small model).}

\item{object2}{Fitted model object with more parameters (i.e., more \code{npar}, large model).}
}
\value{
An object of class \code{"htest"} containing:
\itemize{
\item \code{statistic}: VLMR adjusted test statistic
\item \code{parameter}: Degrees of freedom (\eqn{df = npar_2 - npar_1})
\item \code{p.value}: P-value from \eqn{\chi^2_df} distribution
\item \code{method}: Name of the test
\item \code{data.name}: Model comparison description
}
}
\description{
Conducts a likelihood ratio test to compare the fit of two
models. The test evaluates whether a model with more parameters
provides a significantly better fit than a model with fewer parameters.
}
\details{
Note that since the small model may be nested within the large model, the result
of \code{\link[LCPA]{LRT.test}} may not be accurate and is provided for reference only.
More reliable conclusions should be based on a combination of fit indices (i.e., \code{\link[LCPA]{get.fit.index}}),
classification accuracy measures (i.e., \code{\link[LCPA]{get.entropy}}, \code{\link[LCPA]{get.AvePP}}), and a bootstrapped
likelihood-ratio test (i.e., BLRT, \code{\link[LCPA]{LRT.test.Bootstrap}}, which is very time-consuming).
Above all and the most important criterion, is that the better model is the one that aligns with theoretical
expectations and offers clear interpretability.

The \code{\link[LCPA]{LRT.test}} test statistic is defined as:
\itemize{
\item The models must be \emph{nested} (i.e., the model with fewer parameters is a constrained version of the more one).
\item Both models must be fit on the identical dataset with the same response variables.
\item The test statistic asymptotically follows a chi-square distribution.
}

\deqn{LRT = -2 \times (\text{LogLik}_{1} - \text{LogLik}_{2})}
where:
\itemize{
\item \eqn{\text{LogLik}_{1}}: Log-likelihood of the smaller model (fewer parameters).
\item \eqn{\text{LogLik}_{2}}: Log-likelihood of the larger model (more parameters).
}
Under the null hypothesis (\code{H_0}: small model is true), LRT asymptotically follows
a chi-square distribution with \eqn{df} degrees of freedom.
}
