% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_data.R
\name{ks_heatmap}
\alias{ks_heatmap}
\title{Create a heatmap to visualise if there is not enough evidence to reject the
null hypothesis that two datasets come from the same underlying distribution}
\usage{
ks_heatmap(ks_results)
}
\arguments{
\item{ks_results}{A dataframe with columns \code{name1}, \code{name2}, \code{D}, and
\code{p-value}, obtained using the function ks_compare}
}
\value{
A heatmap plot with all paired comparisons
}
\description{
Create a heatmap to visualise if there is not enough evidence to reject the
null hypothesis that two datasets come from the same underlying distribution
}
\examples{
data <- prepare_data(dplyr::filter(
  carpenter_williams_1995,
  participant == "b"
))
ks_results <- ks_compare(data)
ks_heatmap(ks_results)
}
