% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pipeline.R
\name{run_pipeline}
\alias{run_pipeline}
\title{Run the LABTNSCPSS comorbidity + frailty pipeline}
\usage{
run_pipeline(input_file, col_mapping, coding_system = NULL, out_dir = NULL)
}
\arguments{
\item{input_file}{Path to the input CSV file.}

\item{col_mapping}{Named list mapping standard names to the user's column names.}

\item{coding_system}{Coding system used (e.g., "ICD-10-CA"). Optional; used by internal functions when applicable.}

\item{out_dir}{Output directory for generated files. If NULL, writes next to `input_file`.}
}
\value{
A named list of `data.frame`s returned by `Comorbidity_Frailty_Calculation()`.
  Elements typically include comorbidity and frailty summary tables.
}
\description{
Runs data cleaning, chronic pathology propagation, frailty calculation,
and comorbidity/frailty scoring.
}
