% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sMatrix.R
\name{XMat}
\alias{XMat}
\title{Generate an artificial design matrix}
\usage{
XMat(n, q)
}
\arguments{
\item{n}{The number of data points}

\item{q}{The order of the difference}
}
\value{
A matrix with dimensions \eqn{n} by \eqn{n}, whose elements correspond to the difference matrix.
}
\description{
This matrix corresponds to the difference matrix, transforming the L0 trend filtering model into an inverse statistical problem.
}
\details{
Noticing the correspondence between \eqn{\boldsymbol{D}^{(q+1)}} and \eqn{\boldsymbol{X}^{(q+1)}}, the result of their matrix multiplication is a combination of a zero matrix and an identity matrix. Expressed as \eqn{\boldsymbol{D}^{(q+1)} \boldsymbol{X}^{(q+1)}=(\boldsymbol{O}_{(n-q-1)\times(q+1)},\quad \boldsymbol{I}_{(n-q-1)\times(n-q-1)})}. The result is advantageous for the invertible processing of the original L0 trend filtering problem.
}
\examples{
mat1 <- XMat(n = 10, q = 0)
print(mat1)

mat2 <- XMat(n = 15, q = 1)
print(mat2)

mat3 <- XMat(n = 15, q = 2)
print(mat3)

Mat1 <- DiffMat(n = 10, q = 0)
Mat2 <- DiffMat(n = 15, q = 1)
Mat3 <- DiffMat(n = 15, q = 2)
print(Mat1\%*\%mat1)
print(Mat2\%*\%mat2)
print(Mat3\%*\%mat3)
}
