% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MINERVA2.R
\name{MINERVA2}
\alias{MINERVA2}
\title{Modeling Judgments of Frequency with MINERVA 2}
\usage{
MINERVA2(x, y, ..., sqc, L, dec = NULL)
}
\arguments{
\item{x}{input handled by MINERVA 2. Values -1, 0 and 1 are
allowed. -1 represents the absence of a feature, 0 the
irrelevance of a feature and 1 the presence of a feature.}

\item{y}{another input handled by MINERVA 2. At least two
inputs are needed for the simulation.}

\item{...}{other inputs for modeling.}

\item{sqc}{sequence of the different objects. Each input gets
an ascending number. \code{x} gets the value \code{1},
\code{y} gets the value \code{2}, \code{...} gets the value
\code{3} and so on.
The argument \code{sqc = c(1, 2, 3, 2)} means: first
input \code{x} is processed, second input \code{y} is
processed followed by processing input number three and
fourth, th input \code{y} is used again.
So \code{sqc} contains the frequency information too.
In \code{c(1, 2, 3, 2)}, \code{x} and  the third input
are presented once. The input \code{y} is presented twice.}

\item{L}{learning parameter. This is the proportion of a
correctly stored vector. \code{L = 1} means 100 \% of the input
is processed correctly. If \code{L} is a vector, each input
could be handled differently. So \code{L = c(.5, .6, .9)} means,
input \code{x} is correctly stored to 50 \%, input
\code{y} is stored to 60 \% and the third input (inserted
in \code{...}) is stored with 90 \% probability.}

\item{dec}{decay is not part of the original version of MINERVA 2.
This is just implemented for a better comparison with the other
models of JoF. In \code{dec = NULL}, decay has no effect.
For \code{dec = 'curve'} decay uses a forgetting curve.
If dec is a numeric Vector e. g. \code{dec = c(.8, .9, 1)}
the memory traces are weighted. The first represented trace is
weighted by .8 the second by .9 and the youngest trace by 1.
The value \code{dec = 1} corresponds with the original model.}
}
\value{
MINERVA2 returns the relative judgment of frequency
}
\description{
Modeling Judgments of Frequency with MINERVA 2
}
\details{
Calculations of MINERVA 2 contain four steps.
\deqn{S_{i} = \frac{\sum_{j=1}^{N}{P_{j}T_{ij}}}{N_{i}}}{Si =
(sum(Pj)*Tj) / Ni }
\deqn{A_{i} = S_{i}^{3}}{Ai = Si^3}
\deqn{I = \sum_{i=1}^{M}{A_{i}}}{I = sum(Ai)}
\deqn{relative JoF = \frac{I_{j}}{\sum_{j}^{K}{I_{j}}}}{
relative JoF = Ij / Sum(Ij)}
}
\examples{
#This example is presented in Dougherty,
#Gettys, & Ogden, 1999 (p. 185)
H1 <- c(-1, 1, 0, 1, 0, -1, 1, -1, 0)
H2 <- c(-1, 0, 0, 1, 0, 0, 1, 0, 0)
x <- MINERVA2(H1, H2, sqc = c(2, 1), L = 1)
}
\references{
Dougherty, M. R., Gettys, C. F., & Ogden, E. E.
(1999). MINERVA-DM: A memory processes model for judgments
of likelihood. \emph{Psychological Review, 106}(1), 180.

Hintzman, D. L. (1984). MINERVA 2: A simulation model of human
memory. \emph{Behavior Research Methods, Instruments, and
Computers, 16,}  96–101.
}
