% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvm_imputation.R
\name{tvm.imputation}
\alias{tvm.imputation}
\title{tvm.imputation: Impute Influential Responses in Longitudinal Data}
\usage{
tvm.imputation(
  data,
  subject_col,
  time_col,
  response_col,
  k,
  impute_method = "pmm",
  m = 5
)
}
\arguments{
\item{data}{A data frame containing the longitudinal data.}

\item{subject_col}{Character. The name of the column representing subject IDs.}

\item{time_col}{Character. The name of the column representing time points.}

\item{response_col}{Character. The name of the column representing the response variable.}

\item{k}{Numeric. The number of clusters for the `tvm` function.}

\item{impute_method}{Character. The imputation method to be used in `mice` (default is "pmm").}

\item{m}{Numeric. The number of multiple imputations to be performed (default is 5).}
}
\value{
A data frame with imputed values for the influential response points while maintaining original NA values.
}
\description{
This function identifies influential response values using the `tvm` function, replaces them with NA, and imputes the missing values using the `mice` package.
}
\examples{
infsdata <- infsdata[1:5,]
imptvm <- tvm.imputation(infsdata, "subject_id", "time", "response", k = 3)
head(imptvm)
}
