% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rld.R
\name{rld}
\alias{rld}
\title{Relative Longitudinal Difference (RLD)}
\usage{
rld(data, subject_id, time, response, k = 2, verbose = FALSE)
}
\arguments{
\item{data}{A data frame containing the longitudinal data.}

\item{subject_id}{A column specifying the column name for subject IDs.}

\item{time}{A column specifying different time points that observations are measured like 0 as baseline, 1 as first visit etc.}

\item{response}{A column specifying the column name for response values.}

\item{k}{A numeric value (default = 2) used to define the threshold for detecting influential subjects.}

\item{verbose}{Logical; if TRUE, prints informative messages during execution.}
}
\value{
A list containing:
\item{influential_subjects}{IDs of influential subjects.}
\item{influential_data}{Data frame of influential subjects.}
\item{non_influential_data}{Data frame of non-influential subjects.}
\item{relative_change_plot}{Plot of max relative change per subject.}
\item{longitudinal_plot}{Plot of longitudinal data with influential subjects highlighted.}
\item{IS_table}{A data frame containing the Influence Score (IS) and the Partial Influence Score (PIS) values for each subject at each time point.}
}
\description{
This function identifies influential subjects in longitudinal data based on their relative change
in response over time. It helps in detecting subjects whose response values exhibit significant
fluctuations beyond a specified threshold (k standard deviations).
}
\details{
The function follows these steps:
\itemize{
  \item Computes the relative change in response values over time for each subject.
  \item Calculates the threshold based on k standard deviations from the mean relative change.
  \item Identifies subjects whose relative change exceeds the threshold.
  \item Separates data into influential and non-influential subjects.
  \item Generates visualizations to highlight influential subjects.
}

This method is particularly useful for detecting subjects with extreme response variations in
longitudinal studies.
}
\examples{
data(infsdata)
infsdata <- infsdata[1:5,]
result <- rld(infsdata, "subject_id", "time", "response", k = 2)
print(result$influential_subjects)
head(result$influential_data)
head(result$non_influential_data)

}
\seealso{
tvm, wlm, sld, slm
}
