# IndiAPIs - Access Indian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# BurdwanRiceYield_df

library(testthat)

# Test 1: Confirm the object is a data.frame (not a tibble)
test_that("BurdwanRiceYield_df is a data.frame", {
  expect_s3_class(BurdwanRiceYield_df, "data.frame")
  expect_false("tbl_df" %in% class(BurdwanRiceYield_df))  # Ensure it's not a tibble
})

# Test 2: Confirm it has exactly 2 columns
test_that("BurdwanRiceYield_df has 2 columns", {
  expect_equal(length(BurdwanRiceYield_df), 2)
})

# Test 3: Confirm it has exactly 39 rows
test_that("BurdwanRiceYield_df has 39 rows", {
  expect_equal(nrow(BurdwanRiceYield_df), 39)
})

# Test 4: Confirm column names are correct and in order
test_that("BurdwanRiceYield_df has correct column names", {
  expect_named(BurdwanRiceYield_df, c("Year", "burdwan"))
})

# Test 5: Confirm column types are correct
test_that("BurdwanRiceYield_df columns have correct types", {
  expect_type(BurdwanRiceYield_df$Year, "character")
  expect_type(BurdwanRiceYield_df$burdwan, "double")
})
