% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MINTknown.R
\name{MINTknown}
\alias{MINTknown}
\title{MINTknown}
\usage{
MINTknown(x, y, k, ky, w = FALSE, wy = FALSE, y0)
}
\arguments{
\item{x}{The \eqn{n \times d_X} data matrix of \eqn{X} values.}

\item{y}{The \eqn{n \times d_Y} data matrix of \eqn{Y} values.}

\item{k}{The value of \eqn{k} to be used for estimation of the joint entropy \eqn{H(X,Y)}.}

\item{ky}{The value of \eqn{k} to be used for estimation of the marginal entropy \eqn{H(Y)}.}

\item{w}{The weight vector to used for estimation of the joint entropy \eqn{H(X,Y)}, with the same options as for the \code{\link{KLentropy}} function.}

\item{wy}{The weight vector to used for estimation of the marginal entropy \eqn{H(Y)}, with the same options as for the \code{\link{KLentropy}} function.}

\item{y0}{The data matrix of simulated \eqn{Y} values.}
}
\value{
The \eqn{p}-value corresponding the independence test carried out.
}
\description{
Performs an independence test when it is assumed that the marginal distribution of \eqn{Y} is known and can be simulated from.
}
\examples{
library(mvtnorm)
x=rnorm(1000); y=rnorm(1000);
# Independent univariate normal data
MINTknown(x,y,k=20,ky=30,y0=rnorm(100000))  
library(mvtnorm)
# Dependent univariate normal data
data=rmvnorm(1000,sigma=matrix(c(1,0.5,0.5,1),ncol=2))
# Dependent multivariate normal data
MINTknown(data[,1],data[,2],k=20,ky=30,y0=rnorm(100000))   
Sigma=matrix(c(1,0,0,0,0,1,0,0,0,0,1,0.5,0,0,0.5,1),ncol=4)
data=rmvnorm(1000,sigma=Sigma)
MINTknown(data[,1:3],data[,4],k=20,ky=30,w=TRUE,wy=FALSE,y0=rnorm(100000))

}
\references{
\insertRef{2017arXiv171106642B}{IndepTest}
}
