/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DelegateObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;

public class WrapperObjectMatrix3D
extends ObjectMatrix3D {
    private static final long serialVersionUID = 1L;
    protected ObjectMatrix3D content;

    public WrapperObjectMatrix3D(ObjectMatrix3D objectMatrix3D) {
        block3: {
            if (objectMatrix3D != null) {
                try {
                    this.setUp(objectMatrix3D.slices(), objectMatrix3D.rows(), objectMatrix3D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = objectMatrix3D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized Object getQuick(int n, int n2, int n3) {
        return this.content.getQuick(n, n2, n3);
    }

    public ObjectMatrix3D like(int n, int n2, int n3) {
        return this.content.like(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, Object object) {
        this.content.setQuick(n, n2, n3, object);
    }

    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D denseObjectMatrix1D = new DenseObjectMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseObjectMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseObjectMatrix1D;
    }

    public ObjectMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        return new DelegateObjectMatrix2D(this, 2, n);
    }

    public ObjectMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperObjectMatrix3D wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, n2, this.columns - 1 - n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, Object object) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, object);
            }

            public synchronized Object get(int n, int n2, int n3) {
                return this.content.get(n, n2, this.columns - 1 - n3);
            }

            public synchronized void set(int n, int n2, int n3, Object object) {
                this.content.set(n, n2, this.columns - 1 - n3, object);
            }
        };
        wrapperObjectMatrix3D.isNoView = false;
        return wrapperObjectMatrix3D;
    }

    public ObjectMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        return new DelegateObjectMatrix2D(this, 0, n);
    }

    public ObjectMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperObjectMatrix3D wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2, int n3) {
                return this.content.getQuick(this.slices - 1 - n, n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, Object object) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, object);
            }

            public synchronized Object get(int n, int n2, int n3) {
                return this.content.get(this.slices - 1 - n, n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, Object object) {
                this.content.set(this.slices - 1 - n, n2, n3, object);
            }
        };
        wrapperObjectMatrix3D.isNoView = false;
        return wrapperObjectMatrix3D;
    }

    public ObjectMatrix3D viewDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        WrapperObjectMatrix3D wrapperObjectMatrix3D = null;
        if (n == 0 && n2 == 1 && n3 == 2) {
            wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this);
        } else if (n == 1 && n2 == 0 && n3 == 2) {
            wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n, n3);
                }

                public synchronized void setQuick(int n, int n2, int n3, Object object) {
                    this.content.setQuick(n2, n, n3, object);
                }

                public synchronized Object get(int n, int n2, int n3) {
                    return this.content.get(n2, n, n3);
                }

                public synchronized void set(int n, int n2, int n3, Object object) {
                    this.content.set(n2, n, n3, object);
                }
            };
        } else if (n == 1 && n2 == 2 && n3 == 0) {
            wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n3, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, Object object) {
                    this.content.setQuick(n2, n3, n, object);
                }

                public synchronized Object get(int n, int n2, int n3) {
                    return this.content.get(n2, n3, n);
                }

                public synchronized void set(int n, int n2, int n3, Object object) {
                    this.content.set(n2, n3, n, object);
                }
            };
        } else if (n == 2 && n2 == 1 && n3 == 0) {
            wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n2, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, Object object) {
                    this.content.setQuick(n3, n2, n, object);
                }

                public synchronized Object get(int n, int n2, int n3) {
                    return this.content.get(n3, n2, n);
                }

                public synchronized void set(int n, int n2, int n3, Object object) {
                    this.content.set(n3, n2, n, object);
                }
            };
        } else if (n == 2 && n2 == 0 && n3 == 1) {
            wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n, n2);
                }

                public synchronized void setQuick(int n, int n2, int n3, Object object) {
                    this.content.setQuick(n3, n, n2, object);
                }

                public synchronized Object get(int n, int n2, int n3) {
                    return this.content.get(n3, n, n2);
                }

                public synchronized void set(int n, int n2, int n3, Object object) {
                    this.content.set(n3, n, n2, object);
                }
            };
        }
        int[] nArray = this.shape();
        wrapperObjectMatrix3D.slices = nArray[n];
        wrapperObjectMatrix3D.rows = nArray[n2];
        wrapperObjectMatrix3D.columns = nArray[n3];
        wrapperObjectMatrix3D.isNoView = false;
        return wrapperObjectMatrix3D;
    }

    public ObjectMatrix3D viewPart(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        WrapperObjectMatrix3D wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, Object object) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, object);
            }

            public synchronized Object get(int n4, int n22, int n32) {
                return this.content.get(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void set(int n4, int n22, int n32, Object object) {
                this.content.set(n + n4, n2 + n22, n3 + n32, object);
            }
        };
        wrapperObjectMatrix3D.slices = n4;
        wrapperObjectMatrix3D.rows = n5;
        wrapperObjectMatrix3D.columns = n6;
        wrapperObjectMatrix3D.isNoView = false;
        return wrapperObjectMatrix3D;
    }

    public ObjectMatrix2D viewRow(int n) {
        this.checkRow(n);
        return new DelegateObjectMatrix2D(this, 1, n);
    }

    public ObjectMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperObjectMatrix3D wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, this.rows - 1 - n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, Object object) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, object);
            }

            public synchronized Object get(int n, int n2, int n3) {
                return this.content.get(n, this.rows - 1 - n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, Object object) {
                this.content.set(n, this.rows - 1 - n2, n3, object);
            }
        };
        wrapperObjectMatrix3D.isNoView = false;
        return wrapperObjectMatrix3D;
    }

    public ObjectMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        final int[] nArray4 = nArray;
        final int[] nArray5 = nArray2;
        final int[] nArray6 = nArray3;
        WrapperObjectMatrix3D wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2, int n3) {
                return this.content.getQuick(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void setQuick(int n, int n2, int n3, Object object) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], object);
            }

            public synchronized Object get(int n, int n2, int n3) {
                return this.content.get(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void set(int n, int n2, int n3, Object object) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], object);
            }
        };
        wrapperObjectMatrix3D.slices = nArray.length;
        wrapperObjectMatrix3D.rows = nArray2.length;
        wrapperObjectMatrix3D.columns = nArray3.length;
        wrapperObjectMatrix3D.isNoView = false;
        return wrapperObjectMatrix3D;
    }

    public ObjectMatrix3D viewStrides(final int n, final int n2, final int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperObjectMatrix3D wrapperObjectMatrix3D = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, Object object) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, object);
            }

            public synchronized Object get(int n4, int n22, int n32) {
                return this.content.get(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void set(int n4, int n22, int n32, Object object) {
                this.content.set(n * n4, n2 * n22, n3 * n32, object);
            }
        };
        if (this.slices != 0) {
            wrapperObjectMatrix3D.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            wrapperObjectMatrix3D.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            wrapperObjectMatrix3D.columns = (this.columns - 1) / n3 + 1;
        }
        wrapperObjectMatrix3D.isNoView = false;
        return wrapperObjectMatrix3D;
    }

    protected ObjectMatrix3D getContent() {
        return this.content;
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    protected ObjectMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected ObjectMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        throw new InternalError();
    }
}

