% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata.R
\name{simdata}
\alias{simdata}
\title{Simulation data}
\usage{
simdata(n, p, beta, seed = NULL)
}
\arguments{
\item{n}{Number of observations.}

\item{p}{Number of variables.}

\item{beta}{Regression parameter.}

\item{seed}{(Optional) The random seed for reproducibility. Default is \code{NULL}.}
}
\value{
A list containing the following components:
\describe{
  \item{X}{a matrix of dimensions \code{n x p}.}
  \item{y}{a numeric vector of length \code{n}.}
}
}
\description{
This function generates a toy example. The error term, \eqn{\varepsilon},
and the design matrix, \eqn{X}, are simulated from standard normal
distributions, \eqn{\mathcal{N}(0,1)}, using the \code{\link[stats]{rnorm}}
function. Given the true parameter vector, \eqn{\beta}, the response vector,
\eqn{y}, is calculated as
\deqn{y = X \beta + \varepsilon.}
}
\examples{
simulated_data <- simdata(n = 100, p = 5, beta = c(2, 1, 3, 0, 5))
X <- simulated_data$X
y <- simulated_data$y
X
y

}
\references{
Saleh, A. K. Md. Ehsanes. (2006). \emph{Theory of Preliminary Test and
 Stein‐Type Estimation With Applications}, Wiley.
}
