% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonstdMetrics.R
\name{sera}
\alias{sera}
\title{Squared Error-Relevance Area (SERA)}
\usage{
sera(
  trues,
  preds,
  phi.trues = NULL,
  ph = NULL,
  pl = FALSE,
  m.name = "Model",
  step = 0.001,
  return.err = FALSE,
  norm = FALSE
)
}
\arguments{
\item{trues}{Target values from a test set of a given data set. Should be a vector and have the same size as the variable preds}

\item{preds}{Predicted values given a certain test set of a given data set. Should be a vector and have the same size as the variable preds}

\item{phi.trues}{Relevance of the values in the parameter trues. Use ??phi() for more information. Defaults to NULL}

\item{ph}{The relevance function providing the data points where the pairs of values-relevance are known. Default is NULL}

\item{pl}{Boolean to indicate if an illustration of the curve should be provided. Default is FALSE}

\item{m.name}{Name of the model to be appended in the plot title}

\item{step}{Relevance intervals between 0 (min) and 1 (max). Default 0.001}

\item{return.err}{Boolean to indicate if the errors at each subset of increasing relevance should be returned. Default is FALSE}

\item{norm}{Normalize the SERA values for internal optimisation only (TRUE/FALSE)}
}
\value{
Value for the area under the relevance-squared error curve (SERA)
}
\description{
Computes an approximation of the area under the curve described by squared error of predictions for a sequence of subsets with increasing relevance
}
\examples{
library(IRon)

if(requireNamespace("rpart",quietly=TRUE)) {

   #' data(accel)

   form <- acceleration ~ .

   ind <- sample(1:nrow(accel),0.75*nrow(accel))

   train <- accel[ind,]
   test <- accel[-ind,]

   ph <- phi.control(accel$acceleration)

   m <- rpart::rpart(form, train)
   preds <- as.vector(predict(m,test))

   trues <- test$acceleration
   phi.trues <- phi(test$acceleration,ph)

   sera(trues,preds,phi.trues)
   sera(trues,preds,phi.trues,pl=TRUE, m.name="Regression Trees")
   sera(trues,preds,phi.trues,pl=TRUE, return.err=TRUE)

}

}
